/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.values;

import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.values.NullObject;

class MoneyNull
extends Money
implements NullObject {
    private static final long serialVersionUID = -3546233368167459967L;
    static final String STRING_REPRESENTATION = "MoneyNull";

    MoneyNull() {
        super(0L, null);
    }

    public Decimal getAmount() {
        return Decimal.NULL;
    }

    public boolean isNull() {
        return true;
    }

    public boolean isNotNull() {
        return false;
    }

    public Money max(Money value) {
        return Money.NULL;
    }

    public Money min(Money value) {
        return Money.NULL;
    }

    public Money add(Money m) {
        if (m == null) {
            throw new NullPointerException();
        }
        return this;
    }

    public Money subtract(Money m) {
        if (m == null) {
            throw new NullPointerException();
        }
        return this;
    }

    public Money multiply(int factor) {
        return this;
    }

    public Money multiply(Integer factor) {
        return this;
    }

    public Money multiply(long factor) {
        return this;
    }

    public Money multiply(Decimal d, int roundingMode) {
        if (d == null) {
            throw new NullPointerException();
        }
        return Money.NULL;
    }

    public Money divide(int d, int roundingMode) {
        return this;
    }

    public Money divide(long d, int roundingMode) {
        return this;
    }

    public Money divide(Decimal d, int roundingMode) {
        if (d == null) {
            throw new NullPointerException();
        }
        return this;
    }

    public boolean greaterThan(Money other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean greaterThanOrEqual(Money other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean lessThan(Money other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean lessThanOrEqual(Money other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public int compareTo(Money other) {
        throw new NullPointerException();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Money)) {
            return false;
        }
        return ((Money)o).isNull();
    }

    public String toString() {
        return STRING_REPRESENTATION;
    }
}

