/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.values;

import java.io.Serializable;
import java.util.Currency;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.faktorips.values.Decimal;
import org.faktorips.values.MoneyNull;
import org.faktorips.values.NullObjectSupport;
import org.faktorips.values.xml.MoneyXmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlJavaTypeAdapter(value=MoneyXmlAdapter.class)
public class Money
implements Comparable<Money>,
NullObjectSupport,
Serializable {
    private static final long serialVersionUID = 5639586670329581901L;
    public static final Money NULL = new MoneyNull();
    public static final Currency EUR = Currency.getInstance("EUR");
    public static final Currency USD = Currency.getInstance("USD");
    private static final int[] power10 = new int[]{1, 10, 100, 1000, 10000, 100000};
    private final long internalAmount;
    private final Currency currency;

    public static final Money euro(long euros, int cents) {
        return Money.valueOf(euros, cents, EUR);
    }

    public static final Money euro(long euros) {
        return Money.valueOf(euros, 0, EUR);
    }

    public static final Money usd(long usdollars, int cents) {
        return Money.valueOf(usdollars, cents, USD);
    }

    public static final Money usd(long usdollars) {
        return Money.valueOf(usdollars, 0, USD);
    }

    public static final Money valueOf(String value) {
        if (value == null || value.equals("") || value.equals("MoneyNull")) {
            return NULL;
        }
        String initialValue = value;
        try {
            long majorUnits;
            value = value.trim();
            Currency currency = Currency.getInstance(value.substring(value.length() - 3));
            value = value.substring(0, value.length() - 3);
            int minorUnits = 0;
            int dotPos = value.indexOf(46);
            int fractionDigitsIn = 0;
            if (dotPos == -1) {
                majorUnits = Long.valueOf(value.trim());
            } else {
                String minorUnitsString;
                majorUnits = Long.valueOf(value.substring(0, dotPos).trim());
                if (dotPos < value.length() - 1 && (minorUnitsString = value.substring(dotPos + 1).trim()).length() > 0) {
                    minorUnits = Integer.valueOf(minorUnitsString);
                    fractionDigitsIn = value.substring(dotPos + 1).trim().length();
                }
            }
            int fractionDigits = currency.getDefaultFractionDigits();
            while (fractionDigits > 0 && fractionDigits > fractionDigitsIn && minorUnits > 0) {
                minorUnits *= 10;
                ++fractionDigitsIn;
            }
            if (value.charAt(0) == '-') {
                return Money.valueOf(majorUnits, minorUnits * -1, currency);
            }
            return Money.valueOf(majorUnits, minorUnits, currency);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't parse " + initialValue).initCause(e);
        }
    }

    public static final Money valueOf(long majorUnits, int minorUnits, Currency currency) {
        if (minorUnits > 99) {
            throw new IllegalArgumentException("minorUnits > 99 (is " + minorUnits + ")not allowed");
        }
        long intAmount = majorUnits * (long)power10[currency.getDefaultFractionDigits()] + (long)minorUnits;
        return new Money(intAmount, currency);
    }

    public static final Money valueOf(Decimal value, Currency currency) {
        if (value == null || currency == null || value.isNull()) {
            return NULL;
        }
        if (value.scale() == 0) {
            return Money.valueOf(value.longValue(), 0, currency);
        }
        if (value.scale() > currency.getDefaultFractionDigits()) {
            throw new IllegalArgumentException("Value " + value + " has more digits after the decimal point than the curreny " + currency + " supports!");
        }
        if (value.scale() < currency.getDefaultFractionDigits()) {
            return new Money(value.bigDecimalValue().setScale(currency.getDefaultFractionDigits()).unscaledValue().longValue(), currency);
        }
        return new Money(value.bigDecimalValue().unscaledValue().longValue(), currency);
    }

    public static final Money valueOf(Decimal value, Currency currency, int roundingMode) {
        if (value == null || currency == null || value.isNull()) {
            return NULL;
        }
        if (value.scale() > currency.getDefaultFractionDigits()) {
            value = value.setScale(currency.getDefaultFractionDigits(), roundingMode);
        }
        return Money.valueOf(value.toString() + currency.toString());
    }

    Money(long intAmount, Currency currency) {
        this.internalAmount = intAmount;
        this.currency = currency;
    }

    public Decimal getAmount() {
        return Decimal.valueOf(this.internalAmount, this.currency.getDefaultFractionDigits());
    }

    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isNotNull() {
        return true;
    }

    public Money add(Money value) {
        if (value.isNull()) {
            return NULL;
        }
        if (!this.currency.equals(value.currency)) {
            throw new IllegalArgumentException("Can't add " + this + " and " + value + " because they have different currencies.");
        }
        return new Money(this.internalAmount + value.internalAmount, this.currency);
    }

    public Money subtract(Money value) {
        return new Money(this.internalAmount - value.internalAmount, this.currency);
    }

    public Money multiply(int factor) {
        return new Money(this.internalAmount * (long)factor, this.currency);
    }

    public Money multiply(Integer factor) {
        if (factor == null) {
            return NULL;
        }
        return new Money(this.internalAmount * (long)factor.intValue(), this.currency);
    }

    public Money multiply(long factor) {
        return new Money(this.internalAmount * factor, this.currency);
    }

    public Money multiply(Decimal d, int roundingMode) {
        if (d.isNull()) {
            return NULL;
        }
        long newInternalAmount = d.multiply(this.internalAmount).setScale(0, roundingMode).longValue();
        return new Money(newInternalAmount, this.currency);
    }

    public Money divide(int d, int roundingMode) {
        long newAmount = this.getAmount().divide(d, this.currency.getDefaultFractionDigits(), roundingMode).multiply(power10[this.currency.getDefaultFractionDigits()]).longValue();
        return new Money(newAmount, this.currency);
    }

    public Money divide(long d, int roundingMode) {
        long newAmount = this.getAmount().divide(d, this.currency.getDefaultFractionDigits(), roundingMode).multiply(power10[this.currency.getDefaultFractionDigits()]).longValue();
        return new Money(newAmount, this.currency);
    }

    public Money divide(Decimal d, int roundingMode) {
        if (d.isNull()) {
            return NULL;
        }
        long newAmount = this.getAmount().divide(d, this.currency.getDefaultFractionDigits(), roundingMode).multiply(power10[this.currency.getDefaultFractionDigits()]).longValue();
        return new Money(newAmount, this.currency);
    }

    @Override
    public int compareTo(Money other) {
        if (other.isNull()) {
            throw new NullPointerException();
        }
        if (!this.getCurrency().equals(other.getCurrency())) {
            throw new IllegalArgumentException("The currencys are different. The objects are not comparable ");
        }
        return this.getAmount().compareTo(other.getAmount());
    }

    public boolean greaterThan(Money other) {
        if (other.isNull()) {
            return false;
        }
        return this.compareTo(other) > 0;
    }

    public boolean greaterThanOrEqual(Money other) {
        if (other.isNull()) {
            return false;
        }
        return this.compareTo(other) >= 0;
    }

    public boolean lessThan(Money other) {
        if (other.isNull()) {
            return false;
        }
        return this.compareTo(other) < 0;
    }

    public boolean lessThanOrEqual(Money other) {
        if (other.isNull()) {
            return false;
        }
        return this.compareTo(other) <= 0;
    }

    public Money max(Money value) {
        if (this.greaterThanOrEqual(value)) {
            return this;
        }
        return value;
    }

    public Money min(Money value) {
        if (this.lessThanOrEqual(value)) {
            return this;
        }
        return value;
    }

    public int hashCode() {
        return (int)this.internalAmount;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Money)) {
            return false;
        }
        Money other = (Money)o;
        return this.internalAmount == other.internalAmount && this.currency.equals(other.currency);
    }

    public String toString() {
        return "" + this.getAmount() + ' ' + this.currency.toString();
    }
}

