/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.values;

import org.faktorips.values.DefaultEnumValue;
import org.faktorips.values.EnumType;
import org.faktorips.values.EnumValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEnumType
implements EnumType {
    private final String name;
    private final Class<?> valueClass;
    private DefaultEnumValue[] values = new DefaultEnumValue[0];

    public DefaultEnumType(String name, Class<?> valueClass) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!DefaultEnumValue.class.isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException(valueClass + " is not a subclass of " + DefaultEnumValue.class);
        }
        this.name = name;
        this.valueClass = valueClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    void addValue(DefaultEnumValue newValue) {
        if (this.containsValue(newValue.getId())) {
            throw new IllegalArgumentException("The enum type " + this + " contains already a value " + newValue);
        }
        DefaultEnumValue[] newValues = new DefaultEnumValue[this.values.length + 1];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newValues[this.values.length] = newValue;
        this.values = newValues;
    }

    @Override
    public EnumValue[] getValues() {
        EnumValue[] copy = new DefaultEnumValue[this.values.length];
        System.arraycopy(this.values, 0, copy, 0, this.values.length);
        return copy;
    }

    @Override
    public String[] getValueIds() {
        String[] ids = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            ids[i] = this.values[i].getId();
        }
        return ids;
    }

    @Override
    public boolean containsValue(String id) {
        for (DefaultEnumValue value : this.values) {
            if (!(value.getId() == null ? id == null : value.getId().equals(id))) continue;
            return true;
        }
        return false;
    }

    @Override
    public EnumValue getEnumValue(String id) throws IllegalArgumentException {
        for (DefaultEnumValue value : this.values) {
            if (!(value.getId() == null ? id == null : value.getId().equals(id))) continue;
            return value;
        }
        return null;
    }

    public boolean contains(Object value) {
        if (!(value instanceof EnumValue)) {
            return false;
        }
        return this.contains(value);
    }

    public boolean containsNull() {
        return this.contains(null);
    }

    @Override
    public int getNumOfValues() {
        return this.values.length;
    }

    @Override
    public EnumValue getEnumValue(int index) throws IndexOutOfBoundsException {
        return this.values[index];
    }

    public String toString() {
        return this.name;
    }

    public Object[] getValues(String[] value) {
        Object[] elements = new EnumValue[value.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.getEnumValue(value[i]);
        }
        return elements;
    }
}

