/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.values;

import java.math.BigDecimal;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.faktorips.values.DecimalNull;
import org.faktorips.values.Money;
import org.faktorips.values.NullObjectSupport;
import org.faktorips.values.xml.DecimalXmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlJavaTypeAdapter(value=DecimalXmlAdapter.class)
public class Decimal
extends Number
implements Comparable<Decimal>,
NullObjectSupport {
    private static final long serialVersionUID = -642726667937769164L;
    public static final Decimal NULL = new DecimalNull();
    public static final Decimal ZERO = Decimal.valueOf(0L, 0);
    private final BigDecimal value;

    public static final Decimal sum(Decimal[] values) {
        if (values == null) {
            return NULL;
        }
        Decimal sum = Decimal.valueOf(0L, 0);
        for (Decimal value2 : values) {
            sum = sum.add(value2);
        }
        return sum;
    }

    public static final Decimal valueOf(String s) {
        if (s == null || s.equals("") || s.equals("DecimalNull")) {
            return NULL;
        }
        return new Decimal(new BigDecimal(s));
    }

    public static final Decimal valueOf(BigDecimal value) {
        if (value == null) {
            return NULL;
        }
        return new Decimal(value);
    }

    public static final Decimal valueOf(Integer value) {
        if (value == null) {
            return NULL;
        }
        return Decimal.valueOf(value.longValue(), 0);
    }

    public static final Decimal valueOf(long unscaledValue, int scale) {
        return new Decimal(BigDecimal.valueOf(unscaledValue, scale));
    }

    Decimal(BigDecimal value) {
        this.value = value;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isNotNull() {
        return true;
    }

    public int scale() {
        return this.value.scale();
    }

    public Decimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public Decimal negate() {
        return new Decimal(this.value.negate());
    }

    public int signum() {
        return this.value.signum();
    }

    public Decimal add(Decimal d) {
        if (d == null || d.isNull()) {
            return NULL;
        }
        return new Decimal(this.value.add(d.value));
    }

    public Decimal max(Decimal value) {
        if (this.greaterThanOrEqual(value)) {
            return this;
        }
        return value;
    }

    public Decimal min(Decimal value) {
        if (this.lessThanOrEqual(value)) {
            return this;
        }
        return value;
    }

    public Decimal add(Integer i) {
        if (i == null) {
            return NULL;
        }
        return new Decimal(this.value.add(BigDecimal.valueOf(i.longValue())));
    }

    public Decimal add(int i) {
        return new Decimal(this.value.add(BigDecimal.valueOf(i)));
    }

    public Decimal subtract(Decimal d) {
        if (d == null || d.isNull()) {
            return NULL;
        }
        return new Decimal(this.value.subtract(d.value));
    }

    public Decimal subtract(int i) {
        return new Decimal(this.value.subtract(BigDecimal.valueOf(i)));
    }

    public Decimal multiply(Decimal d) {
        if (d == null || d.isNull()) {
            return NULL;
        }
        return new Decimal(this.value.multiply(d.value));
    }

    public Money multiply(Money m, int roundingMode) {
        if (m == null) {
            return Money.NULL;
        }
        return m.multiply(this, roundingMode);
    }

    public Decimal multiply(Integer i) {
        if (i == null) {
            return NULL;
        }
        return new Decimal(this.value.multiply(BigDecimal.valueOf(i.longValue())));
    }

    public Decimal multiply(int i) {
        return new Decimal(this.value.multiply(BigDecimal.valueOf(i)));
    }

    public Decimal multiply(long l) {
        return new Decimal(this.value.multiply(BigDecimal.valueOf(l)));
    }

    public Decimal divide(int value, int scale, int roundingMode) {
        return this.divide(Decimal.valueOf(value, 0), scale, roundingMode);
    }

    public Decimal divide(long value, int scale, int roundingMode) {
        return this.divide(Decimal.valueOf(value, 0), scale, roundingMode);
    }

    public Decimal divide(Decimal d, int scale, int roundingMode) {
        if (this.isNull() || d.isNull()) {
            return this;
        }
        return new Decimal(this.value.divide(d.value, scale, roundingMode));
    }

    public Decimal setScale(int scale, int roundingMode) {
        return new Decimal(this.value.setScale(scale, roundingMode));
    }

    public Decimal round(int precision, int roundingMode) {
        return this.setScale(precision, roundingMode).setScale(this.scale(), 7);
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    public int compareTo(Decimal d) {
        return this.value.compareTo(d.value);
    }

    public boolean greaterThan(Decimal d) {
        if (d == null || d.isNull()) {
            return false;
        }
        return this.value.compareTo(d.value) > 0;
    }

    public boolean greaterThanOrEqual(Decimal d) {
        if (d == null || d.isNull()) {
            return false;
        }
        return this.value.compareTo(d.value) >= 0;
    }

    public boolean lessThan(Decimal d) {
        if (d == null || d.isNull()) {
            return false;
        }
        return this.value.compareTo(d.value) < 0;
    }

    public boolean lessThanOrEqual(Decimal d) {
        if (d == null || d.isNull()) {
            return false;
        }
        return this.value.compareTo(d.value) <= 0;
    }

    @Deprecated
    public boolean equalsIgnoreScale(Decimal d) {
        if (d == null || d.isNull()) {
            return false;
        }
        return this.value.compareTo(d.value) == 0;
    }

    @Deprecated
    public boolean notEqualsIgnoreScale(Decimal d) {
        if (d == null || d.isNull()) {
            return false;
        }
        return this.value.compareTo(d.value) != 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Decimal)) {
            return false;
        }
        Decimal other = (Decimal)o;
        if (other.isNull()) {
            return false;
        }
        return this.value.compareTo(other.value) == 0;
    }

    public int hashCode() {
        String s = this.value.toString();
        if (s.indexOf(46) > 0) {
            int pos;
            for (pos = s.length() - 1; pos >= 0 && s.charAt(pos) == '0'; --pos) {
            }
            if (pos >= 0 && s.charAt(pos) == '.') {
                --pos;
            }
            s = s.substring(0, pos + 1);
        }
        if (s.equals("0")) {
            return 0;
        }
        return s.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

