/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.values;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class DateUtil {
    public static final String gregorianCalendarToIsoDateString(GregorianCalendar calendar) {
        if (calendar == null) {
            return "";
        }
        int month = calendar.get(2) + 1;
        int date = calendar.get(5);
        return calendar.get(1) + "-" + (month < 10 ? "0" + month : "" + month) + "-" + (date < 10 ? "0" + date : "" + date);
    }

    public static final String dateToIsoDateString(Date date) {
        if (date == null) {
            return "";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return DateUtil.gregorianCalendarToIsoDateString(calendar);
    }

    public static final GregorianCalendar parseIsoDateStringToGregorianCalendar(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(s, "-");
            int year = Integer.parseInt(tokenizer.nextToken());
            int month = Integer.parseInt(tokenizer.nextToken());
            int date = Integer.parseInt(tokenizer.nextToken());
            return new GregorianCalendar(year, month - 1, date);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't parse " + s + " to a date!");
        }
    }

    public static final boolean isIsoDate(String value) {
        if (value == null) {
            return false;
        }
        String regex = "^\\d{4}-\\d{1,2}-\\d{1,2}$";
        return Pattern.matches(regex, value);
    }

    public static final Date parseIsoDateStringToDate(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return DateUtil.parseIsoDateStringToGregorianCalendar(s).getTime();
    }
}

