/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider.ejbclient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.faktorips.productdataservice.IProductDataService;
import org.faktorips.productdataservice.XmlTimestampData;
import org.faktorips.runtime.IVersionChecker;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.ReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.productdataprovider.AbstractProductDataProvider;
import org.faktorips.runtime.productdataprovider.DataModifiedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EjbProductDataProvider
extends AbstractProductDataProvider {
    public final IProductDataService productDataService;
    public final String version;
    private final ReadonlyTableOfContents toc;

    EjbProductDataProvider(String beanName, InitialContext initialContext, IVersionChecker versionChecker) {
        super(versionChecker);
        try {
            String sessionBenaName = beanName;
            this.productDataService = (IProductDataService)initialContext.lookup(sessionBenaName);
            this.version = this.getBaseVersion();
            this.toc = this.loadToc();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private ReadonlyTableOfContents loadToc() {
        XmlTimestampData timestampData = this.productDataService.getTocData();
        try {
            Document doc = this.getDocumentBuilder().parse(new InputSource(new StringReader(timestampData.xmlData)));
            Element tocElement = doc.getDocumentElement();
            ReadonlyTableOfContents toc = new ReadonlyTableOfContents();
            toc.initFromXml(tocElement);
            return toc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public InputStream getEnumContentAsStream(EnumContentTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData = this.productDataService.getEnumContent(tocEntry.getImplementationClassName());
        this.throwExceptionIfExpired(tocEntry.getImplementationClassName(), timestampData.version);
        return new ByteArrayInputStream(timestampData.xmlData.getBytes());
    }

    public Element getProductCmptData(ProductCmptTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData = this.productDataService.getProductCmptData(tocEntry.getIpsObjectId());
        this.throwExceptionIfExpired(tocEntry.getIpsObjectId(), timestampData.version);
        try {
            Document doc = this.getDocumentBuilder().parse(new InputSource(new StringReader(timestampData.xmlData)));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Element getProductCmptGenerationData(GenerationTocEntry tocEntry) throws DataModifiedException {
        Element docElement = this.getProductCmptData(tocEntry.getParent());
        NodeList nl = docElement.getChildNodes();
        DateTime validFrom = tocEntry.getValidFrom();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element genElement;
            DateTime generationValidFrom;
            if (!"Generation".equals(nl.item(i).getNodeName()) || !validFrom.equals((Object)(generationValidFrom = DateTime.parseIso((String)(genElement = (Element)nl.item(i)).getAttribute("validFrom"))))) continue;
            return genElement;
        }
        throw new RuntimeException("Can't find the generation for the toc entry " + tocEntry);
    }

    public InputStream getTableContentAsStream(TableContentTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData = this.productDataService.getTableContent(tocEntry.getIpsObjectQualifiedName());
        this.throwExceptionIfExpired(tocEntry.getIpsObjectQualifiedName(), timestampData.version);
        return new ByteArrayInputStream(timestampData.xmlData.getBytes());
    }

    public Element getTestcaseElement(TestCaseTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData = this.productDataService.getTestCaseData(tocEntry.getIpsObjectQualifiedName());
        this.throwExceptionIfExpired(tocEntry.getIpsObjectId(), timestampData.version);
        try {
            Document doc = this.getDocumentBuilder().parse(new InputSource(new StringReader(timestampData.xmlData)));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized IReadonlyTableOfContents getToc() {
        return this.toc;
    }

    public String getBaseVersion() {
        return this.productDataService.getProductDataVersion();
    }

    private void throwExceptionIfExpired(String ipsObject, String version) throws DataModifiedException {
        if (!this.getVersionChecker().isCompatibleVersion(this.getVersion(), version)) {
            DataModifiedException e = new DataModifiedException("Data has changed: " + ipsObject, this.version, version);
            throw e;
        }
    }
}

