/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponseImpl;
import org.apache.openejb.server.httpd.HttpServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class OpenEJBHttpServer
implements HttpServer {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.HTTPSERVER, (String)"org.apache.openejb.util.resources");
    private HttpListener listener;

    public OpenEJBHttpServer() {
        this(OpenEJBHttpServer.getHttpListenerRegistry());
    }

    public static HttpListenerRegistry getHttpListenerRegistry() {
        SystemInstance systemInstance = SystemInstance.get();
        HttpListenerRegistry registry = (HttpListenerRegistry)systemInstance.getComponent(HttpListenerRegistry.class);
        if (registry == null) {
            registry = new HttpListenerRegistry();
            systemInstance.setComponent(HttpListenerRegistry.class, (Object)registry);
        }
        return registry;
    }

    public OpenEJBHttpServer(HttpListener listener) {
        this.listener = listener;
    }

    public HttpListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Socket socket) throws ServiceException, IOException {
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        try {
            URI socketURI = new URI("http://" + socket.getLocalAddress().getHostName() + ":" + socket.getLocalPort());
            this.processRequest(socketURI, in, out);
        }
        catch (Throwable e) {
            log.error("Unexpected error", e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Throwable t) {
                log.error("Encountered problem while closing connection with client: " + t.getMessage());
            }
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(InputStream in, OutputStream out)");
    }

    public void init(Properties props) throws Exception {
    }

    public void start() throws ServiceException {
    }

    public void stop() throws ServiceException {
    }

    public String getName() {
        return "httpd";
    }

    public int getPort() {
        return 0;
    }

    public String getIP() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(URI socketURI, InputStream in, OutputStream out) {
        HttpResponseImpl response = null;
        try {
            response = this.process(socketURI, in);
        }
        catch (Throwable t) {
            response = HttpResponseImpl.createError(t.getMessage(), t);
        }
        finally {
            try {
                response.writeMessage(out);
            }
            catch (Throwable t2) {
                log.error("Could not write response", t2);
            }
        }
    }

    private HttpResponseImpl process(URI socketURI, InputStream in) throws OpenEJBException {
        HttpRequestImpl req = new HttpRequestImpl(socketURI);
        HttpResponseImpl res = new HttpResponseImpl();
        try {
            req.readMessage(in);
            res.setRequest(req);
        }
        catch (Throwable t) {
            res.setCode(400);
            res.setResponseString("Could not read the request");
            res.getPrintWriter().println(t.getMessage());
            t.printStackTrace(res.getPrintWriter());
            log.error("BAD REQUEST", t);
            throw new OpenEJBException("Could not read the request.\n" + t.getClass().getName() + ":\n" + t.getMessage(), t);
        }
        String location = null;
        try {
            URI uri = req.getURI();
            location = uri.getPath();
            int querry = location.indexOf("?");
            if (querry != -1) {
                location = location.substring(0, querry);
            }
        }
        catch (Throwable t) {
            throw new OpenEJBException("Could not determine the module " + location + "\n" + t.getClass().getName() + ":\n" + t.getMessage());
        }
        try {
            this.listener.onMessage(req, res);
        }
        catch (Throwable t) {
            throw new OpenEJBException("Error occurred while executing the module " + location + "\n" + t.getClass().getName() + ":\n" + t.getMessage(), t);
        }
        return res;
    }
}

