/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestImpl
implements HttpRequest {
    private static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    protected static final String EJBSESSIONID = "EJBSESSIONID";
    private HttpRequest.Method method;
    private URI uri;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String> formParams = new HashMap<String, String>();
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private final Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> cookies;
    private byte[] body;
    private InputStream in;
    private int length;
    private String contentType;
    private final URI socketURI;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public HttpRequestImpl(URI socketURI) {
        this.socketURI = socketURI;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public String getFormParameter(String name) {
        return this.formParams.get(name);
    }

    public Map<String, String> getFormParameters() {
        return new HashMap<String, String>(this.formParams);
    }

    public Map<String, String> getQueryParameters() {
        return new HashMap<String, String>(this.queryParams);
    }

    public String getQueryParameter(String name) {
        return this.queryParams.get(name);
    }

    @Override
    public HttpRequest.Method getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public int getContentLength() {
        return this.length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    protected void readMessage(InputStream input) throws IOException {
        DataInputStream in = new DataInputStream(input);
        this.readRequestLine(in);
        this.readHeaders(in);
        this.readBody(in);
        this.parameters.putAll(this.getFormParameters());
        this.parameters.putAll(this.getQueryParameters());
    }

    private void readRequestLine(DataInput in) throws IOException {
        String line;
        try {
            line = in.readLine();
        }
        catch (Exception e) {
            throw new IOException("Could not read the HTTP Request Line :" + e.getClass().getName() + " : " + e.getMessage());
        }
        StringTokenizer lineParts = new StringTokenizer(line, " ");
        this.parseMethod(lineParts);
        this.parseURI(lineParts);
    }

    private void parseMethod(StringTokenizer lineParts) throws IOException {
        String token;
        try {
            token = lineParts.nextToken();
        }
        catch (Exception e) {
            throw new IOException("Could not parse the HTTP Request Method :" + e.getClass().getName() + " : " + e.getMessage());
        }
        if (token.equalsIgnoreCase("GET")) {
            this.method = HttpRequest.Method.GET;
        } else if (token.equalsIgnoreCase("POST")) {
            this.method = HttpRequest.Method.POST;
        } else {
            this.method = HttpRequest.Method.UNSUPPORTED;
            throw new IOException("Unsupported HTTP Request Method :" + token);
        }
    }

    private void parseURI(StringTokenizer lineParts) throws IOException {
        String token;
        try {
            token = lineParts.nextToken();
        }
        catch (Exception e) {
            throw new IOException("Could not parse the HTTP Request Method :" + e.getClass().getName() + " : " + e.getMessage());
        }
        try {
            this.uri = new URI(this.socketURI.toString() + token);
        }
        catch (URISyntaxException e) {
            throw new IOException("Malformed URI :" + token + " Exception: " + e.getMessage());
        }
        this.parseQueryParams(this.uri.getQuery());
    }

    private void parseQueryParams(String query) {
        if (query == null) {
            return;
        }
        StringTokenizer parameters = new StringTokenizer(query, "&");
        while (parameters.hasMoreTokens()) {
            String name;
            StringTokenizer param = new StringTokenizer(parameters.nextToken(), "=");
            if (!param.hasMoreTokens() || (name = URLDecoder.decode(param.nextToken())) == null) continue;
            String value = !param.hasMoreTokens() ? "" : URLDecoder.decode(param.nextToken());
            this.queryParams.put(name, value);
        }
    }

    private void readHeaders(DataInput in) throws IOException {
        while (true) {
            String value;
            int colonIndex;
            String name;
            String hf;
            try {
                hf = in.readLine();
            }
            catch (Exception e) {
                throw new IOException("Could not read the HTTP Request Header Field :" + e.getClass().getName() + " : " + e.getMessage());
            }
            if (hf == null || hf.equals("") || (name = hf.substring(0, colonIndex = hf.indexOf(58))) == null || (value = hf.substring(colonIndex + 1, hf.length())) == null) break;
            value = value.trim();
            this.headers.put(name, value);
        }
        String host = this.headers.get("Host");
        if (host != null) {
            String hostName;
            int port = this.uri.getPort();
            int idx = host.indexOf(":");
            if (idx >= 0) {
                hostName = host.substring(0, idx);
                try {
                    port = Integer.parseInt(host.substring(idx + 1));
                }
                catch (NumberFormatException ignore) {}
            } else {
                hostName = host;
            }
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), hostName, port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
        }
    }

    private void readBody(DataInput in) throws IOException {
        this.length = this.parseContentLength();
        this.contentType = this.getHeader("Content-Type");
        if (this.method == HttpRequest.Method.POST && FORM_URL_ENCODED.equals(this.contentType)) {
            StringTokenizer param;
            String name;
            String rawParams;
            try {
                this.body = this.readContent(in);
                rawParams = new String(this.body);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Could not read the HTTP Request Body: " + e.getMessage()).initCause(e);
            }
            StringTokenizer parameters = new StringTokenizer(rawParams, "&");
            while (parameters.hasMoreTokens() && (name = URLDecoder.decode((param = new StringTokenizer(parameters.nextToken(), "=")).nextToken())) != null) {
                String value = param.hasMoreTokens() ? URLDecoder.decode(param.nextToken()) : "";
                if (value == null) {
                    value = "";
                }
                this.formParams.put(name, value);
            }
        } else if (this.method == HttpRequest.Method.POST && CHUNKED.equals(this.headers.get(TRANSFER_ENCODING))) {
            try {
                String sizeString;
                int size;
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                String line = in.readLine();
                while (line != null && (size = Integer.parseInt(sizeString = line.split(";", 2)[0], 16)) != 0) {
                    byte[] chunk = new byte[size];
                    in.readFully(chunk);
                    out.write(chunk);
                    in.readLine();
                    line = in.readLine();
                }
                this.body = out.toByteArray();
                this.in = new ByteArrayInputStream(this.body);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to read chunked body").initCause(e);
            }
        } else if (this.method == HttpRequest.Method.POST) {
            this.body = this.readContent(in);
            this.in = new ByteArrayInputStream(this.body);
        } else {
            this.body = new byte[0];
            this.in = new ByteArrayInputStream(this.body);
        }
    }

    private byte[] readContent(DataInput in) throws IOException {
        if (this.length >= 0) {
            byte[] body = new byte[this.length];
            in.readFully(body);
            return body;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            boolean atLineStart = true;
            while (true) {
                byte b;
                if ((b = in.readByte()) == 13) {
                    out.write(b);
                    b = in.readByte();
                }
                if (b == 10) {
                    if (atLineStart) break;
                    atLineStart = true;
                } else {
                    atLineStart = false;
                }
                out.write(b);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        byte[] body = out.toByteArray();
        return body;
    }

    private int parseContentLength() {
        String len = this.getHeader("Content-Length");
        int length = -1;
        if (len != null) {
            try {
                length = Integer.parseInt(len);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return length;
    }

    protected Map getCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        this.cookies = new HashMap<String, String>();
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader == null) {
            return this.cookies;
        }
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer token = new StringTokenizer(tokens.nextToken(), "=");
            String name = token.nextToken();
            String value = token.nextToken();
            this.cookies.put(name, value);
        }
        return this.cookies;
    }

    protected String getCookie(String name) {
        return (String)this.getCookies().get(name);
    }

    @Override
    public HttpSession getSession(boolean create) {
        return null;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }
}

