/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.tutorial.hausrat.internal.hausrat;

import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.tutorial.hausrat.hausrat.IHausratVertrag;
import org.faktorips.tutorial.hausrat.hausrat.IHausratZusatzdeckung;
import org.faktorips.tutorial.hausrat.hausrat.IHausratZusatzdeckungstyp;
import org.faktorips.tutorial.hausrat.hausrat.IHausratZusatzdeckungstypGen;
import org.faktorips.tutorial.hausrat.internal.hausrat.HausratVertrag;
import org.faktorips.tutorial.modell.base.IDeckungstyp;
import org.faktorips.tutorial.modell.base.IVertrag;
import org.faktorips.tutorial.modell.internal.base.Deckung;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.w3c.dom.Element;

@XmlRootElement(name="HausratZusatzdeckung")
public class HausratZusatzdeckung
extends Deckung
implements IHausratZusatzdeckung {
    @XmlElement(name="versSumme", nillable=true)
    private Money versSumme = Money.NULL;
    @XmlAttribute(name="hausratVertrag.id")
    @XmlIDREF
    private HausratVertrag hausratVertrag;

    public HausratZusatzdeckung() {
    }

    public HausratZusatzdeckung(IHausratZusatzdeckungstyp productCmpt) {
        super((IDeckungstyp)productCmpt);
    }

    public Decimal getVersSummenFaktor() {
        return this.getHausratZusatzdeckungstypGen().getVersSummenFaktor();
    }

    public Money getMaxVersSumme() {
        return this.getHausratZusatzdeckungstypGen().getMaxVersSumme();
    }

    @Override
    public Money getVersSumme() {
        this.ermittleVersSumme();
        return this.versSumme;
    }

    public Money berechneJahresbasisbeitragInternal() {
        Money oldValue = this.getJahresbasisbeitrag();
        Money newValue = Money.NULL;
        this.ermittleVersSumme();
        IHausratZusatzdeckungstypGen hausratZusatzdeckungstypGen = this.getHausratZusatzdeckungstypGen();
        if (hausratZusatzdeckungstypGen != null) {
            newValue = hausratZusatzdeckungstypGen.berechneJahresbasisbeitrag(this, this.getHausratVertrag());
        }
        this.notifyChangeListeners(new PropertyChangeEvent(this, "jahresbasisbeitrag", oldValue, newValue));
        return newValue;
    }

    @Override
    public IHausratVertrag getHausratVertrag() {
        return this.hausratVertrag;
    }

    @Override
    public void ermittleVersSumme() {
        Money oldValue = this.versSumme;
        IHausratZusatzdeckungstypGen gen = this.getHausratZusatzdeckungstypGen();
        if (gen == null || this.getHausratVertrag() == null) {
            this.versSumme = Money.NULL;
        } else {
            Money maxVs;
            Decimal faktor = gen.getVersSummenFaktor();
            Money vsVertrag = this.getHausratVertrag().getVersSumme();
            Money vs = vsVertrag.multiply(faktor, 4);
            this.versSumme = vs.greaterThan(maxVs = gen.getMaxVersSumme()) ? maxVs : vs;
        }
        this.notifyChangeListeners(new PropertyChangeEvent(this, "versSumme", oldValue, this.versSumme));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("versSumme".equals(evt.getPropertyName())) {
            this.berechneJahresbasisbeitrag();
        }
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public IHausratZusatzdeckungstyp getHausratZusatzdeckungstyp() {
        return (IHausratZusatzdeckungstyp)this.getProductComponent();
    }

    @Override
    public IHausratZusatzdeckungstypGen getHausratZusatzdeckungstypGen() {
        return (IHausratZusatzdeckungstypGen)this.getProductCmptGeneration();
    }

    @Override
    public void setHausratZusatzdeckungstyp(IHausratZusatzdeckungstyp hausratZusatzdeckungstyp, boolean initPropertiesWithConfiguratedDefaults) {
        this.setProductComponent((IProductComponent)hausratZusatzdeckungstyp);
        if (initPropertiesWithConfiguratedDefaults) {
            this.initialize();
        }
    }

    public void effectiveFromHasChanged() {
        super.effectiveFromHasChanged();
    }

    public IModelObject getParentModelObject() {
        if (this.hausratVertrag != null) {
            return this.hausratVertrag;
        }
        return null;
    }

    public void setHausratVertragInternal(IHausratVertrag newParent) {
        if (this.getHausratVertrag() == newParent) {
            return;
        }
        IModelObject parent = this.getParentModelObject();
        if (newParent != null && parent != null) {
            throw new RuntimeException("HausratZusatzdeckung kann nicht dem Parent Objekt der Klasse HausratVertrag hinzugefuegt werden, da das Objekt bereits einem anderen Parent Objekt zugeordnet ist.");
        }
        this.hausratVertrag = (HausratVertrag)newParent;
    }

    public IVertrag getVertrag() {
        if (this.hausratVertrag != null) {
            return this.hausratVertrag;
        }
        return null;
    }

    public void notifyChangeListeners(PropertyChangeEvent event) {
        super.notifyChangeListeners(event);
        if (this.hausratVertrag != null) {
            this.hausratVertrag.notifyChangeListeners(event);
        }
    }

    protected void initPropertiesFromXml(Map<String, String> propMap, IRuntimeRepository productRepository) {
        super.initPropertiesFromXml(propMap, productRepository);
        if (propMap.containsKey("versSumme")) {
            this.versSumme = Money.valueOf((String)propMap.get("versSumme"));
        }
    }

    protected AbstractModelObject createChildFromXml(Element childEl) {
        AbstractModelObject newChild = super.createChildFromXml(childEl);
        if (newChild != null) {
            return newChild;
        }
        return null;
    }

    public boolean validateSelf(MessageList ml, IValidationContext context) {
        return super.validateSelf(ml, context);
    }

    public void validateDependants(MessageList ml, IValidationContext context) {
        super.validateDependants(ml, context);
    }
}

