/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.tutorial.hausrat.internal.hausrat;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.faktorips.runtime.AssociationChangedEvent;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.AbstractConfigurableModelObject;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.tutorial.hausrat.hausrat.IHausratGrunddeckung;
import org.faktorips.tutorial.hausrat.hausrat.IHausratGrunddeckungstyp;
import org.faktorips.tutorial.hausrat.hausrat.IHausratProdukt;
import org.faktorips.tutorial.hausrat.hausrat.IHausratProduktGen;
import org.faktorips.tutorial.hausrat.hausrat.IHausratVertrag;
import org.faktorips.tutorial.hausrat.hausrat.IHausratZusatzdeckung;
import org.faktorips.tutorial.hausrat.hausrat.IHausratZusatzdeckungstyp;
import org.faktorips.tutorial.hausrat.hausrat.enums.Versicherungsort;
import org.faktorips.tutorial.hausrat.internal.hausrat.HausratGrunddeckung;
import org.faktorips.tutorial.hausrat.internal.hausrat.HausratZusatzdeckung;
import org.faktorips.tutorial.hausrat.internal.hausrat.Tarifzonentabelle;
import org.faktorips.tutorial.hausrat.internal.hausrat.TarifzonentabelleRow;
import org.faktorips.tutorial.modell.base.IDeckung;
import org.faktorips.tutorial.modell.base.IProdukt;
import org.faktorips.tutorial.modell.internal.base.Vertrag;
import org.faktorips.values.Money;
import org.faktorips.valueset.IntegerRange;
import org.faktorips.valueset.MoneyRange;
import org.w3c.dom.Element;

@XmlRootElement(name="HausratVertrag")
public class HausratVertrag
extends Vertrag
implements IHausratVertrag {
    @XmlElement(name="plz", nillable=true)
    private String plz = null;
    @XmlElement(name="wohnflaeche", nillable=true)
    private Integer wohnflaeche = null;
    @XmlElement(name="vorschlagVersSumme", nillable=true)
    private Money vorschlagVersSumme = Money.NULL;
    @XmlElement(name="versSumme", nillable=true)
    private Money versSumme = Money.NULL;
    @XmlElement(name="vort", nillable=true)
    private Versicherungsort vort = null;
    @XmlElement(name="HausratGrunddeckung", type=HausratGrunddeckung.class)
    private HausratGrunddeckung hausratGrunddeckung = null;
    @XmlElement(name="HausratZusatzdeckung", type=HausratZusatzdeckung.class)
    @XmlElementWrapper(name="HausratZusatzdeckungen")
    private List<IHausratZusatzdeckung> hausratZusatzdeckungen = new ArrayList<IHausratZusatzdeckung>();

    public HausratVertrag() {
    }

    public HausratVertrag(IHausratProdukt productCmpt) {
        super((IProdukt)productCmpt);
    }

    public Money getVorschlagVersSummeProQm() {
        return this.getHausratProduktGen().getVorschlagVersSummeProQm();
    }

    @Override
    public String getPlz() {
        return this.plz;
    }

    @Override
    public void setPlz(String newValue) {
        String oldPlz = this.plz;
        this.plz = newValue;
        this.notifyChangeListeners(new PropertyChangeEvent(this, "plz", oldPlz, this.plz));
        this.notifyChangeListeners(new PropertyChangeEvent(this, "tarifzone", null, this.getTarifzone()));
    }

    @Override
    public String getTarifzone() {
        if (this.plz == null) {
            return "I";
        }
        IRuntimeRepository repository = this.getHausratProdukt().getRepository();
        Tarifzonentabelle tabelle = Tarifzonentabelle.getInstance(repository);
        TarifzonentabelleRow row = tabelle.findRow(this.plz);
        if (row == null) {
            return "I";
        }
        return row.getTarifzone();
    }

    @Override
    public IntegerRange getRangeForWohnflaeche(IValidationContext context) {
        return this.getHausratProduktGen().getRangeForWohnflaeche(context);
    }

    @Override
    public Integer getWohnflaeche() {
        return this.wohnflaeche;
    }

    @Override
    public void setWohnflaeche(Integer newValue) {
        Integer oldWohnflaeche = this.wohnflaeche;
        this.wohnflaeche = newValue;
        this.notifyChangeListeners(new PropertyChangeEvent(this, "wohnflaeche", oldWohnflaeche, this.wohnflaeche));
    }

    @Override
    public Money getVorschlagVersSumme() {
        return this.vorschlagVersSumme;
    }

    @Override
    public MoneyRange getRangeForVersSumme(IValidationContext context) {
        return this.getHausratProduktGen().getRangeForVersSumme(context);
    }

    @Override
    public Money getVersSumme() {
        return this.versSumme;
    }

    @Override
    public void setVersSumme(Money newValue) {
        Money oldVersSumme = this.versSumme;
        this.versSumme = newValue;
        this.notifyChangeListeners(new PropertyChangeEvent(this, "versSumme", oldVersSumme, this.versSumme));
    }

    @Override
    public Versicherungsort getVort() {
        return this.vort;
    }

    @Override
    public void setVort(Versicherungsort newValue) {
        Versicherungsort oldVort = this.vort;
        this.vort = newValue;
        this.notifyChangeListeners(new PropertyChangeEvent(this, "vort", (Object)oldVort, (Object)this.vort));
    }

    @Override
    public IHausratGrunddeckung getHausratGrunddeckung() {
        return this.hausratGrunddeckung;
    }

    @Override
    public void setHausratGrunddeckung(IHausratGrunddeckung newObject) {
        HausratGrunddeckung oldHausratGrunddeckung = this.hausratGrunddeckung;
        this.setHausratGrunddeckungInternal(newObject);
        this.notifyChangeListeners((PropertyChangeEvent)new AssociationChangedEvent((Object)this, "hausratGrunddeckung", (Object)oldHausratGrunddeckung, (Object)newObject));
    }

    public void setHausratGrunddeckungInternal(IHausratGrunddeckung newObject) {
        if (this.hausratGrunddeckung != null) {
            this.hausratGrunddeckung.setHausratVertragInternal(null);
        }
        if (newObject != null) {
            ((HausratGrunddeckung)newObject).setHausratVertragInternal(this);
        }
        this.hausratGrunddeckung = (HausratGrunddeckung)newObject;
    }

    @Override
    public IHausratGrunddeckung newHausratGrunddeckung() {
        HausratGrunddeckung newHausratGrunddeckung = new HausratGrunddeckung();
        this.setHausratGrunddeckungInternal(newHausratGrunddeckung);
        newHausratGrunddeckung.initialize();
        this.notifyChangeListeners((PropertyChangeEvent)new AssociationChangedEvent((Object)this, "hausratGrunddeckung", null, (Object)newHausratGrunddeckung));
        return newHausratGrunddeckung;
    }

    @Override
    public IHausratGrunddeckung newHausratGrunddeckung(IHausratGrunddeckungstyp iHausratGrunddeckungstyp) {
        HausratGrunddeckung newHausratGrunddeckung = new HausratGrunddeckung(iHausratGrunddeckungstyp);
        this.setHausratGrunddeckungInternal(newHausratGrunddeckung);
        newHausratGrunddeckung.initialize();
        this.notifyChangeListeners((PropertyChangeEvent)new AssociationChangedEvent((Object)this, "hausratGrunddeckung", null, (Object)newHausratGrunddeckung));
        return newHausratGrunddeckung;
    }

    @Override
    public int getNumOfHausratZusatzdeckungen() {
        return this.hausratZusatzdeckungen.size();
    }

    @Override
    public boolean containsHausratZusatzdeckung(IHausratZusatzdeckung objectToTest) {
        return this.hausratZusatzdeckungen.contains(objectToTest);
    }

    @Override
    public List<IHausratZusatzdeckung> getHausratZusatzdeckungen() {
        return Collections.unmodifiableList(this.hausratZusatzdeckungen);
    }

    @Override
    public IHausratZusatzdeckung getHausratZusatzdeckung(int index) {
        return this.hausratZusatzdeckungen.get(index);
    }

    @Override
    public IHausratZusatzdeckung newHausratZusatzdeckung() {
        HausratZusatzdeckung newHausratZusatzdeckung = new HausratZusatzdeckung();
        this.addHausratZusatzdeckungInternal(newHausratZusatzdeckung);
        newHausratZusatzdeckung.initialize();
        this.notifyChangeListeners((PropertyChangeEvent)new AssociationChangedEvent((Object)this, "hausratZusatzdeckungen", null, (Object)newHausratZusatzdeckung));
        return newHausratZusatzdeckung;
    }

    @Override
    public IHausratZusatzdeckung newHausratZusatzdeckung(IHausratZusatzdeckungstyp iHausratZusatzdeckungstyp) {
        HausratZusatzdeckung newHausratZusatzdeckung = new HausratZusatzdeckung(iHausratZusatzdeckungstyp);
        this.addHausratZusatzdeckungInternal(newHausratZusatzdeckung);
        newHausratZusatzdeckung.initialize();
        this.notifyChangeListeners((PropertyChangeEvent)new AssociationChangedEvent((Object)this, "hausratZusatzdeckungen", null, (Object)newHausratZusatzdeckung));
        return newHausratZusatzdeckung;
    }

    @Override
    public void addHausratZusatzdeckung(IHausratZusatzdeckung objectToAdd) {
        this.addHausratZusatzdeckungInternal(objectToAdd);
        this.notifyChangeListeners((PropertyChangeEvent)new AssociationChangedEvent((Object)this, "hausratZusatzdeckungen", null, (Object)objectToAdd));
    }

    public void addHausratZusatzdeckungInternal(IHausratZusatzdeckung objectToAdd) {
        if (objectToAdd == null) {
            throw new NullPointerException("Can't add null to association HausratZusatzdeckung of " + this);
        }
        if (this.hausratZusatzdeckungen.contains(objectToAdd)) {
            return;
        }
        ((HausratZusatzdeckung)objectToAdd).setHausratVertragInternal(this);
        this.hausratZusatzdeckungen.add(objectToAdd);
    }

    @Override
    public void removeHausratZusatzdeckung(IHausratZusatzdeckung objectToRemove) {
        if (objectToRemove == null) {
            return;
        }
        if (this.hausratZusatzdeckungen.remove(objectToRemove)) {
            ((HausratZusatzdeckung)objectToRemove).setHausratVertragInternal(null);
        }
        this.notifyChangeListeners((PropertyChangeEvent)new AssociationChangedEvent((Object)this, "hausratZusatzdeckungen", (Object)objectToRemove, null));
    }

    public int getNumOfDeckungen() {
        return this.getNumOfDeckungenInternal();
    }

    public List<IDeckung> getDeckungen() {
        ArrayList<IDeckung> result = new ArrayList<IDeckung>(this.getNumOfDeckungenInternal());
        if (this.getHausratGrunddeckung() != null) {
            result.add(this.getHausratGrunddeckung());
        }
        result.addAll(this.getHausratZusatzdeckungen());
        return result;
    }

    private int getNumOfDeckungenInternal() {
        int num = 0;
        num += this.hausratGrunddeckung == null ? 0 : 1;
        return num += this.getNumOfHausratZusatzdeckungen();
    }

    @Override
    public void ermittleVorschlagVersicherungssumme() {
        Money oldValue = this.vorschlagVersSumme;
        if (!Money.NULL.equals((Object)this.getVorschlagVersSummeProQm())) {
            this.vorschlagVersSumme = this.getVorschlagVersSummeProQm().multiply(this.getWohnflaeche());
        }
        this.notifyChangeListeners(new PropertyChangeEvent(this, "vorschlagVersSumme", oldValue, this.vorschlagVersSumme));
    }

    public void initialize() {
        super.initialize();
        if (this.getHausratProduktGen() == null) {
            return;
        }
        this.wohnflaeche = this.getHausratProduktGen().getDefaultValueWohnflaeche();
        this.versSumme = this.getHausratProduktGen().getDefaultValueVersSumme();
    }

    @Override
    public IHausratProdukt getHausratProdukt() {
        return (IHausratProdukt)this.getProductComponent();
    }

    @Override
    public IHausratProduktGen getHausratProduktGen() {
        return (IHausratProduktGen)this.getProductCmptGeneration();
    }

    @Override
    public void setHausratProdukt(IHausratProdukt hausratProdukt, boolean initPropertiesWithConfiguratedDefaults) {
        this.setProductComponent((IProductComponent)hausratProdukt);
        if (initPropertiesWithConfiguratedDefaults) {
            this.initialize();
        }
    }

    public void effectiveFromHasChanged() {
        super.effectiveFromHasChanged();
        if (this.hausratGrunddeckung != null) {
            this.hausratGrunddeckung.effectiveFromHasChanged();
        }
        for (AbstractConfigurableModelObject abstractConfigurableModelObject : this.hausratZusatzdeckungen) {
            abstractConfigurableModelObject.effectiveFromHasChanged();
        }
    }

    public Calendar getEffectiveFromAsCalendar() {
        return super.getEffectiveFromAsCalendar();
    }

    protected void initPropertiesFromXml(Map<String, String> propMap, IRuntimeRepository productRepository) {
        super.initPropertiesFromXml(propMap, productRepository);
        if (propMap.containsKey("plz")) {
            this.plz = propMap.get("plz");
        }
        if (propMap.containsKey("wohnflaeche")) {
            Integer n = this.wohnflaeche = propMap.get("wohnflaeche") == null || propMap.get("wohnflaeche").equals("") ? null : new Integer(propMap.get("wohnflaeche"));
        }
        if (propMap.containsKey("vorschlagVersSumme")) {
            this.vorschlagVersSumme = Money.valueOf((String)propMap.get("vorschlagVersSumme"));
        }
        if (propMap.containsKey("versSumme")) {
            this.versSumme = Money.valueOf((String)propMap.get("versSumme"));
        }
        if (propMap.containsKey("vort")) {
            this.vort = propMap.get("vort") == null || propMap.get("vort").equals("") ? null : Versicherungsort.getValueById(propMap.get("vort"));
        }
    }

    protected AbstractModelObject createChildFromXml(Element childEl) {
        AbstractModelObject newChild = super.createChildFromXml(childEl);
        if (newChild != null) {
            return newChild;
        }
        if ("HausratGrunddeckung".equals(childEl.getNodeName())) {
            String className = childEl.getAttribute("class");
            if (className.length() > 0) {
                try {
                    HausratGrunddeckung hausratGrunddeckungLocalVar = (HausratGrunddeckung)Class.forName(className).newInstance();
                    this.setHausratGrunddeckung(hausratGrunddeckungLocalVar);
                    return hausratGrunddeckungLocalVar;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return (AbstractModelObject)this.newHausratGrunddeckung();
        }
        if ("HausratZusatzdeckung".equals(childEl.getNodeName())) {
            String className = childEl.getAttribute("class");
            if (className.length() > 0) {
                try {
                    HausratZusatzdeckung hausratZusatzdeckungLocalVar = (HausratZusatzdeckung)Class.forName(className).newInstance();
                    this.addHausratZusatzdeckung(hausratZusatzdeckungLocalVar);
                    return hausratZusatzdeckungLocalVar;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return (AbstractModelObject)this.newHausratZusatzdeckung();
        }
        return null;
    }

    public boolean validateSelf(MessageList ml, IValidationContext context) {
        return super.validateSelf(ml, context);
    }

    public void validateDependants(MessageList ml, IValidationContext context) {
        super.validateDependants(ml, context);
    }
}

