/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.tutorial.hausrat.internal.hausrat;

import java.beans.PropertyChangeEvent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.tutorial.hausrat.hausrat.IHausratGrunddeckung;
import org.faktorips.tutorial.hausrat.hausrat.IHausratGrunddeckungstyp;
import org.faktorips.tutorial.hausrat.hausrat.IHausratGrunddeckungstypGen;
import org.faktorips.tutorial.hausrat.hausrat.IHausratVertrag;
import org.faktorips.tutorial.hausrat.internal.hausrat.HausratGrunddeckungstypGen;
import org.faktorips.tutorial.hausrat.internal.hausrat.HausratVertrag;
import org.faktorips.tutorial.hausrat.internal.hausrat.TariftabelleHausrat;
import org.faktorips.tutorial.hausrat.internal.hausrat.TariftabelleHausratRow;
import org.faktorips.tutorial.modell.base.IDeckungstyp;
import org.faktorips.tutorial.modell.base.IVertrag;
import org.faktorips.tutorial.modell.internal.base.Deckung;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.w3c.dom.Element;

@XmlRootElement(name="HausratGrunddeckung")
public class HausratGrunddeckung
extends Deckung
implements IHausratGrunddeckung {
    @XmlAttribute(name="hausratVertrag.id")
    @XmlIDREF
    private HausratVertrag hausratVertrag;

    public HausratGrunddeckung() {
    }

    public HausratGrunddeckung(IHausratGrunddeckungstyp productCmpt) {
        super((IDeckungstyp)productCmpt);
    }

    @Override
    public IHausratVertrag getHausratVertrag() {
        return this.hausratVertrag;
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public IHausratGrunddeckungstyp getHausratGrunddeckungstyp() {
        return (IHausratGrunddeckungstyp)this.getProductComponent();
    }

    @Override
    public IHausratGrunddeckungstypGen getHausratGrunddeckungstypGen() {
        return (IHausratGrunddeckungstypGen)this.getProductCmptGeneration();
    }

    @Override
    public void setHausratGrunddeckungstyp(IHausratGrunddeckungstyp hausratGrunddeckungstyp, boolean initPropertiesWithConfiguratedDefaults) {
        this.setProductComponent((IProductComponent)hausratGrunddeckungstyp);
        if (initPropertiesWithConfiguratedDefaults) {
            this.initialize();
        }
    }

    public void effectiveFromHasChanged() {
        super.effectiveFromHasChanged();
    }

    public TariftabelleHausrat getTariftabelle() {
        HausratGrunddeckungstypGen productCmpt = (HausratGrunddeckungstypGen)this.getHausratGrunddeckungstypGen();
        if (productCmpt == null) {
            return null;
        }
        return productCmpt.getTariftabelle();
    }

    public IModelObject getParentModelObject() {
        if (this.hausratVertrag != null) {
            return this.hausratVertrag;
        }
        return null;
    }

    public void setHausratVertragInternal(IHausratVertrag newParent) {
        if (this.getHausratVertrag() == newParent) {
            return;
        }
        IModelObject parent = this.getParentModelObject();
        if (newParent != null && parent != null) {
            throw new RuntimeException("HausratGrunddeckung kann nicht dem Parent Objekt der Klasse HausratVertrag hinzugefuegt werden, da das Objekt bereits einem anderen Parent Objekt zugeordnet ist.");
        }
        this.hausratVertrag = (HausratVertrag)newParent;
    }

    public IVertrag getVertrag() {
        if (this.hausratVertrag != null) {
            return this.hausratVertrag;
        }
        return null;
    }

    public void notifyChangeListeners(PropertyChangeEvent event) {
        super.notifyChangeListeners(event);
        if (this.hausratVertrag != null) {
            this.hausratVertrag.notifyChangeListeners(event);
        }
    }

    protected AbstractModelObject createChildFromXml(Element childEl) {
        AbstractModelObject newChild = super.createChildFromXml(childEl);
        if (newChild != null) {
            return newChild;
        }
        return null;
    }

    public boolean validateSelf(MessageList ml, IValidationContext context) {
        return super.validateSelf(ml, context);
    }

    public void validateDependants(MessageList ml, IValidationContext context) {
        super.validateDependants(ml, context);
    }

    public Money berechneJahresbasisbeitragInternal() {
        TariftabelleHausrat tabelle = this.getTariftabelle();
        TariftabelleHausratRow row = null;
        if (tabelle != null) {
            row = tabelle.findRow(this.getHausratVertrag().getTarifzone());
        }
        if (row == null) {
            return Money.NULL;
        }
        Money vs = this.getHausratVertrag().getVersSumme();
        Decimal beitragssatz = row.getBeitragssatz();
        return vs.divide(1000, 4).multiply(beitragssatz, 4);
    }
}

