/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.test.IpsTestFailure;
import org.faktorips.runtime.test.IpsTestListener;

public class IpsTestResult {
    private List<IpsTestListener> listeners = new ArrayList<IpsTestListener>();
    private List<IpsTestFailure> failures = new ArrayList<IpsTestFailure>(100);

    public int countFailures() {
        return this.failures.size();
    }

    public void addListener(IpsTestListener listener) {
        this.listeners.add(listener);
    }

    public void remove(IpsTestListener listener) {
        this.listeners.remove(listener);
    }

    public void run(IpsTest2 test) {
        test.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(IpsTestCaseBase test) {
        try {
            this.notifyListenerAboutStart(test);
            test.executeBusinessLogic();
            test.executeAsserts(this);
        }
        catch (Throwable t) {
            this.addFailure(new IpsTestFailure(test, t));
        }
        finally {
            this.notifyListenerAboutFinished(test);
        }
    }

    private void notifyListenerAboutStart(IpsTest2 test) {
        for (IpsTestListener listener : this.listeners) {
            listener.testStarted(test);
        }
    }

    private void notifyListenerAboutFinished(IpsTest2 test) {
        for (IpsTestListener listener : this.listeners) {
            listener.testFinished(test);
        }
    }

    public void addFailure(IpsTestFailure failure) {
        this.failures.add(failure);
        for (IpsTestListener listener : this.listeners) {
            listener.testFailureOccured(failure);
        }
    }
}

