/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.test.IpsTestFailure;
import org.faktorips.runtime.test.IpsTestListener;
import org.faktorips.runtime.test.IpsTestResult;

public class IpsTestCaseJUnitAdapter
extends TestCase
implements IpsTestListener {
    private IpsTestCaseBase ipsTestCase;
    private List<IpsTestFailure> failures = new ArrayList<IpsTestFailure>();
    private static final String FAILUREFORMAT_FAILUREIN = "Failure in: \"{0}\"";
    private static final String FAILUREFORMAT_OBJECT = ", Object: \"{1}\",";
    private static final String FAILUREFORMAT_ATTRIBUTE = ", Attribute: \"{2}\".";
    private static final String FAILUREFORMAT_EXPECTED = ", expected: \"{3}\"";
    private static final String FAILUREFORMAT_ACTUAL = " but was: \"{4}\"";

    public IpsTestCaseJUnitAdapter(IpsTestCaseBase ipsTestCase) {
        super(ipsTestCase.getName());
        this.ipsTestCase = ipsTestCase;
    }

    public IpsTestCaseJUnitAdapter(String name) {
        super(name);
    }

    public void testNothing() {
    }

    public void runTest() throws Throwable {
        if (this.ipsTestCase == null) {
            return;
        }
        IpsTestResult ipsTestResult = new IpsTestResult();
        ipsTestResult.addListener(this);
        this.ipsTestCase.run(ipsTestResult);
        if (this.failures.size() > 0) {
            StringBuffer failureBuffer = new StringBuffer(this.failures.size() * 40);
            for (IpsTestFailure failure : this.failures) {
                if (failure.isError()) {
                    throw failure.getThrowable();
                }
                if (failureBuffer.length() > 0) {
                    failureBuffer.append(System.getProperty("line.separator"));
                }
                failureBuffer.append(this.failureToString(failure));
            }
            IpsTestCaseJUnitAdapter.fail((String)failureBuffer.toString());
        }
    }

    private String failureToString(IpsTestFailure failure) {
        String failureFormat = FAILUREFORMAT_FAILUREIN;
        String failureActual = FAILUREFORMAT_ACTUAL;
        String failureExpected = FAILUREFORMAT_EXPECTED;
        String failureFormatAttribute = FAILUREFORMAT_ATTRIBUTE;
        String failureFormatObject = FAILUREFORMAT_OBJECT;
        ArrayList<String> failureDetails = new ArrayList<String>(5);
        failureDetails.add(failure.getTestCase() != null ? failure.getTestCase().getQualifiedName() : null);
        failureDetails.add(failure.getTestObject());
        failureDetails.add(failure.getTestedAttribute());
        failureDetails.add(failure.getExpectedValue() != null ? failure.getExpectedValue().toString() : null);
        failureDetails.add(failure.getActualValue() != null ? failure.getActualValue().toString() : null);
        if (failureDetails.size() > 3) {
            failureFormat = failureFormat + (failureDetails.get(2) != null ? failureExpected : "");
        }
        if (failureDetails.size() > 4) {
            failureFormat = failureFormat + (failureDetails.get(3) != null ? failureActual : "");
        }
        if (failureDetails.size() > 1) {
            failureFormat = failureFormat + (failureDetails.get(0) != null ? failureFormatObject : "");
        }
        if (failureDetails.size() > 2) {
            failureFormat = failureFormat + (failureDetails.get(1) != null ? failureFormatAttribute : "");
        }
        return MessageFormat.format(failureFormat, failureDetails.toArray());
    }

    public void testStarted(IpsTest2 test) {
    }

    public void testFinished(IpsTest2 arg0) {
    }

    public void testFailureOccured(IpsTestFailure f) {
        this.failures.add(f);
    }
}

