/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.faktorips.runtime.IVersionChecker;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.ReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.productdataprovider.AbstractProductDataProvider;
import org.faktorips.runtime.productdataprovider.DataModifiedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ClassLoaderProductDataProvider
extends AbstractProductDataProvider {
    private final ClassLoader cl;
    private final boolean checkTocModifications;
    private final String tocFileLastModified;
    private final ReadonlyTableOfContents toc;
    private final URL tocUrl;

    public ClassLoaderProductDataProvider(ClassLoader classLoader, String tocResourcePath, boolean checkTocModifications) {
        super(new IVersionChecker(){

            public boolean isCompatibleVersion(String oldVersion, String newVersion) {
                return oldVersion.equals(newVersion);
            }
        });
        this.cl = classLoader;
        this.tocUrl = this.cl.getResource(tocResourcePath);
        if (this.tocUrl == null) {
            throw new IllegalArgumentException("Can' find table of contents file " + tocResourcePath);
        }
        this.checkTocModifications = checkTocModifications;
        this.toc = this.loadToc();
        this.tocFileLastModified = this.getBaseVersion();
    }

    private ReadonlyTableOfContents loadToc() {
        Document doc;
        InputStream is = null;
        try {
            is = this.tocUrl.openStream();
            doc = this.getDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading table of contents from " + this.tocUrl.getFile(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            Element tocElement = doc.getDocumentElement();
            ReadonlyTableOfContents toc = new ReadonlyTableOfContents();
            toc.initFromXml(tocElement);
            return toc;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating toc from xml.", e);
        }
    }

    public Element getProductCmptData(ProductCmptTocEntry tocEntry) throws DataModifiedException {
        String resourcePath = tocEntry.getXmlResourceName();
        Element documentElement = this.getDocumentElement(resourcePath);
        this.throwExceptionIfModified(tocEntry.getIpsObjectId(), this.getBaseVersion());
        return documentElement;
    }

    public Element getProductCmptGenerationData(GenerationTocEntry tocEntry) throws DataModifiedException {
        Element docElement = this.getDocumentElement(tocEntry.getParent().getXmlResourceName());
        NodeList nl = docElement.getChildNodes();
        DateTime validFrom = tocEntry.getValidFrom();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element genElement;
            DateTime generationValidFrom;
            if (!"Generation".equals(nl.item(i).getNodeName()) || !validFrom.equals(generationValidFrom = DateTime.parseIso((genElement = (Element)nl.item(i)).getAttribute("validFrom")))) continue;
            this.throwExceptionIfModified(tocEntry.getParent().getIpsObjectId(), this.getBaseVersion());
            return genElement;
        }
        throw new RuntimeException("Can't find the generation for the toc entry " + tocEntry);
    }

    public Element getTestcaseElement(TestCaseTocEntry tocEntry) throws DataModifiedException {
        String resourcePath = tocEntry.getXmlResourceName();
        Element documentElement = this.getDocumentElement(resourcePath);
        this.throwExceptionIfModified(tocEntry.getIpsObjectId(), this.getBaseVersion());
        return documentElement;
    }

    public InputStream getTableContentAsStream(TableContentTocEntry tocEntry) throws DataModifiedException {
        InputStream resourceAsStream = this.cl.getResourceAsStream(tocEntry.getXmlResourceName());
        this.throwExceptionIfModified(tocEntry.getIpsObjectId(), this.getBaseVersion());
        return resourceAsStream;
    }

    public InputStream getEnumContentAsStream(EnumContentTocEntry tocEntry) throws DataModifiedException {
        InputStream resourceAsStream = this.cl.getResourceAsStream(tocEntry.getXmlResourceName());
        this.throwExceptionIfModified(tocEntry.getIpsObjectId(), this.getBaseVersion());
        return resourceAsStream;
    }

    public synchronized ReadonlyTableOfContents getToc() {
        return this.toc;
    }

    private Element getDocumentElement(String resourcePath) {
        Document doc;
        InputStream is = this.cl.getResourceAsStream(resourcePath);
        if (is == null) {
            throw new RuntimeException("Can't find resource " + resourcePath);
        }
        try {
            doc = this.getDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse xml resource " + resourcePath, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close the input stream of the resource: " + resourcePath, e);
            }
        }
        Element element = doc.getDocumentElement();
        if (element == null) {
            throw new RuntimeException("Xml resource " + resourcePath + " hasn't got a document element.");
        }
        return element;
    }

    public String getVersion() {
        return this.tocFileLastModified;
    }

    public String getBaseVersion() {
        if (this.checkTocModifications) {
            String lastMod = "";
            try {
                URLConnection connection = this.tocUrl.openConnection();
                if (connection instanceof JarURLConnection) {
                    JarURLConnection jarUrlConnection = (JarURLConnection)connection;
                    URL jarUrl = jarUrlConnection.getJarFileURL();
                    File jarFile = new File(jarUrl.toURI());
                    lastMod = "" + jarFile.lastModified();
                } else {
                    File tocFile = new File(this.tocUrl.getFile());
                    lastMod = "" + tocFile.lastModified();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot get last modification stamp of toc url", e);
            }
            return lastMod;
        }
        if (this.toc != null) {
            return this.toc.getProductDataVersion();
        }
        return "";
    }

    private void throwExceptionIfModified(String name, String timestamp) throws DataModifiedException {
        if (this.checkTocModifications && !this.getVersionChecker().isCompatibleVersion(this.getVersion(), timestamp)) {
            throw new DataModifiedException("Data has changed: " + name, this.getVersion(), timestamp);
        }
    }
}

