/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.faktorips.runtime.IVersionChecker;
import org.faktorips.runtime.productdataprovider.IProductDataProvider;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractProductDataProvider
implements IProductDataProvider {
    protected static final String MODIFIED_EXCEPTION_MESSAGE = "Data has changed: ";
    private static ThreadLocal<DocumentBuilder> docBuilderHolder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            return AbstractProductDataProvider.createDocumentBuilder();
        }
    };
    private final IVersionChecker versionChecker;

    private static final DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new RuntimeException("Error creating document builder.", e1);
        }
        builder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return builder;
    }

    public AbstractProductDataProvider(IVersionChecker versionChecker) {
        this.versionChecker = versionChecker;
    }

    protected DocumentBuilder getDocumentBuilder() {
        return docBuilderHolder.get();
    }

    public boolean isCompatibleToBaseVersion() {
        return this.getVersionChecker().isCompatibleVersion(this.getVersion(), this.getBaseVersion());
    }

    public abstract String getBaseVersion();

    public IVersionChecker getVersionChecker() {
        return this.versionChecker;
    }
}

