/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;
import org.faktorips.runtime.modeltype.IModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractModelElement
implements IModelElement {
    private Map<String, Object> extPropertyValues = null;
    private String name = null;
    private AbstractRuntimeRepository repository;

    public AbstractModelElement(AbstractRuntimeRepository repository) {
        this.repository = repository;
    }

    @Override
    public Object getExtensionPropertyValue(String propertyId) {
        if (this.extPropertyValues == null) {
            return null;
        }
        return this.extPropertyValues.get(propertyId);
    }

    public void setExtensionPropertyValue(String propertyId, Object value) {
        if (this.extPropertyValues == null) {
            this.extPropertyValues = new HashMap<String, Object>(5);
        }
        this.extPropertyValues.put(propertyId, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initFromXml(XMLStreamReader parser) throws XMLStreamException {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeLocalName(i).equals("name")) continue;
            this.name = parser.getAttributeValue(i);
        }
    }

    @Override
    public Set<String> getExtensionPropertyIds() {
        if (this.extPropertyValues == null) {
            return new HashSet<String>(0);
        }
        return this.extPropertyValues.keySet();
    }

    @Override
    public void initExtPropertiesFromXml(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!parser.getLocalName().equals("Value")) break;
                    this.initExtPropertyValueFromXML(parser);
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("ExtensionProperties")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    private void initExtPropertyValueFromXML(XMLStreamReader parser) throws XMLStreamException {
        String id = null;
        boolean isNull = true;
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (parser.getAttributeLocalName(i).equals("id")) {
                id = parser.getAttributeValue(i);
                continue;
            }
            if (!parser.getAttributeLocalName(i).equals("isNull")) continue;
            isNull = Boolean.valueOf(parser.getAttributeValue(i));
        }
        if (isNull) {
            this.setExtensionPropertyValue(id, null);
        } else {
            int event = parser.next();
            while (event != 8) {
                switch (event) {
                    case 4: {
                        value.append(parser.getText().trim());
                        break;
                    }
                    case 12: {
                        value.append(parser.getText().trim());
                        break;
                    }
                    case 2: {
                        if (!parser.getLocalName().equals("Value")) break;
                        this.setExtensionPropertyValue(id, value.toString());
                        return;
                    }
                }
                event = parser.next();
            }
        }
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.repository;
    }

    protected AbstractRuntimeRepository getAbstractRepository() {
        return this.repository;
    }

    Class<?> loadClass(String className) {
        try {
            return Class.forName(className, true, this.repository.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

