/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.List;
import java.util.Set;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadonlyTableOfContents
implements IReadonlyTableOfContents {
    public static final String TOC_XML_ELEMENT = "FaktorIps-TableOfContents";
    public static final String PRODUCT_DATA_VERSION_XML_ELEMENT = "productDataVersion";
    private String productDataVersion;

    public final void initFromXml(Element tocElement) {
        this.productDataVersion = tocElement.getAttribute(PRODUCT_DATA_VERSION_XML_ELEMENT);
        if (this.productDataVersion == null) {
            this.productDataVersion = "0";
        }
        NodeList nl = tocElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element entryElement = (Element)nl.item(i);
            this.internalAddEntry(TocEntryObject.createFromXml(entryElement));
        }
    }

    protected abstract void internalAddEntry(TocEntryObject var1);

    @Override
    public abstract ProductCmptTocEntry getProductCmptTocEntry(String var1);

    @Override
    public abstract ProductCmptTocEntry getProductCmptTocEntry(String var1, String var2);

    @Override
    public abstract List<ProductCmptTocEntry> getProductCmptTocEntries();

    @Override
    public abstract List<ProductCmptTocEntry> getProductCmptTocEntries(String var1);

    @Override
    public abstract List<TableContentTocEntry> getTableTocEntries();

    @Override
    public abstract List<TestCaseTocEntry> getTestCaseTocEntries();

    @Override
    public abstract TestCaseTocEntry getTestCaseTocEntryByQName(String var1);

    @Override
    public abstract TableContentTocEntry getTableTocEntryByClassname(String var1);

    @Override
    public abstract TableContentTocEntry getTableTocEntryByQualifiedTableName(String var1);

    @Override
    public abstract Set<ModelTypeTocEntry> getModelTypeTocEntries();

    @Override
    public abstract EnumContentTocEntry getEnumContentTocEntry(String var1);

    @Override
    public abstract Set<EnumXmlAdapterTocEntry> getEnumXmlAdapterTocEntries();

    @Override
    public String getProductDataVersion() {
        return this.productDataVersion;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("TOC");
        buf.append(System.getProperty("line.separator"));
        List<ProductCmptTocEntry> entries = this.getProductCmptTocEntries();
        for (ProductCmptTocEntry entry : entries) {
            buf.append(entry.toString());
            buf.append(System.getProperty("line.separator"));
        }
        List<TableContentTocEntry> tableEntries = this.getTableTocEntries();
        for (TableContentTocEntry entry : tableEntries) {
            buf.append(entry.toString());
            buf.append(System.getProperty("line.separator"));
        }
        List<TestCaseTocEntry> testEntries = this.getTestCaseTocEntries();
        for (TestCaseTocEntry entry : testEntries) {
            buf.append(entry.toString());
            buf.append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }
}

