/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import org.faktorips.runtime.internal.EnumValues;
import org.faktorips.runtime.internal.Range;
import org.faktorips.runtime.internal.XmlUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ValueToXmlHelper {
    public static final void addValueToElement(String value, Element el, String tagName) {
        Element valueEl = el.getOwnerDocument().createElement(tagName);
        el.appendChild(valueEl);
        valueEl.setAttribute("isNull", value == null ? "true" : "false");
        if (value != null) {
            valueEl.appendChild(el.getOwnerDocument().createTextNode(value));
        }
    }

    public static final String getValueFromElement(Element el, String tagName) {
        Element valueEl = XmlUtil.getFirstElement(el, tagName);
        if (valueEl == null) {
            return null;
        }
        return ValueToXmlHelper.getValueFromElement(valueEl);
    }

    public static final String getValueFromElement(Element valueEl) {
        if (Boolean.valueOf(valueEl.getAttribute("isNull")).equals(Boolean.TRUE)) {
            return null;
        }
        Text text = XmlUtil.getTextNode(valueEl);
        if (text != null) {
            return text.getData();
        }
        CDATASection cdata = XmlUtil.getFirstCDataSection(valueEl);
        String result = "";
        if (cdata != null) {
            result = cdata.getData();
        }
        return result;
    }

    public static final Range getRangeFromElement(Element el, String tagName) {
        Element valueSetEl = XmlUtil.getFirstElement(el, tagName);
        if (valueSetEl == null) {
            return null;
        }
        Element rangeEl = XmlUtil.getFirstElement(valueSetEl, "Range");
        if (rangeEl == null) {
            return null;
        }
        boolean containsNull = Boolean.valueOf(rangeEl.getAttribute("containsNull"));
        String lowerBound = ValueToXmlHelper.getValueFromElement(rangeEl, "LowerBound");
        String upperBound = ValueToXmlHelper.getValueFromElement(rangeEl, "UpperBound");
        String step = ValueToXmlHelper.getValueFromElement(rangeEl, "Step");
        return new Range(lowerBound, upperBound, step, containsNull);
    }

    public static final EnumValues getEnumValueSetFromElement(Element el, String tagName) {
        Element valueSetEl = XmlUtil.getFirstElement(el, tagName);
        if (valueSetEl == null) {
            return null;
        }
        Element enumEl = XmlUtil.getFirstElement(valueSetEl, "Enum");
        if (enumEl == null) {
            return null;
        }
        NodeList valueElements = enumEl.getElementsByTagName("Value");
        String[] values = new String[valueElements.getLength()];
        boolean containsNull = false;
        for (int i = 0; i < valueElements.getLength(); ++i) {
            Element valueEl = (Element)valueElements.item(i);
            values[i] = ValueToXmlHelper.getValueFromElement(valueEl, "Data");
            if (values[i] != null) continue;
            containsNull = true;
        }
        return new EnumValues(values, containsNull);
    }

    private ValueToXmlHelper() {
    }
}

