/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.ReadOnlyBinaryRangeTree;
import org.faktorips.runtime.internal.TableSaxHandler;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Table
implements ITable {
    protected List rows;

    protected abstract void addRow(List<String> var1, IRuntimeRepository var2);

    protected abstract void initKeyMaps();

    public void initFromXml(InputStream is, IRuntimeRepository productRepository) throws Exception {
        this.rows = new ArrayList(200);
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse(new InputSource(is), (DefaultHandler)new TableSaxHandler(this, productRepository));
        ((ArrayList)this.rows).trimToSize();
        this.initKeyMaps();
    }

    protected boolean isNull(Element valueElement) {
        return Boolean.valueOf(valueElement.getAttribute("isNull"));
    }

    protected Map convert(Map map, ReadOnlyBinaryRangeTree.KeyType[] treeTypes) {
        return this.convert(map, treeTypes, 0);
    }

    private Map convert(Map map, ReadOnlyBinaryRangeTree.KeyType[] treeTypes, int level) {
        HashMap returnValue = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (treeTypes.length == level) {
                return map;
            }
            returnValue.put(entry.getKey(), this.generateTree((Map)entry.getValue(), treeTypes, level));
        }
        return returnValue;
    }

    protected ReadOnlyBinaryRangeTree generateTree(Map map, ReadOnlyBinaryRangeTree.KeyType[] treeTypes) {
        return this.generateTree(map, treeTypes, 0);
    }

    private ReadOnlyBinaryRangeTree generateTree(Map map, ReadOnlyBinaryRangeTree.KeyType[] treeTypes, int level) {
        Map nextLevel = this.convert(map, treeTypes, level + 1);
        return new ReadOnlyBinaryRangeTree(nextLevel, treeTypes[level]);
    }

    protected Map getMap(Map searchMap, Object key) {
        HashMap returnValue = (HashMap)searchMap.get(key);
        if (returnValue == null) {
            returnValue = new HashMap();
            searchMap.put(key, returnValue);
        }
        return returnValue;
    }

    protected Map getMap(Map searchMap, Comparable lowerBound, Comparable upperBound) {
        ReadOnlyBinaryRangeTree.TwoColumnKey key = new ReadOnlyBinaryRangeTree.TwoColumnKey(lowerBound, upperBound);
        HashMap returnValue = (HashMap)searchMap.get(key);
        if (returnValue == null) {
            returnValue = new HashMap();
            searchMap.put(key, returnValue);
        }
        return returnValue;
    }

    protected Object getValue(Map map, Object key, Comparable[] treeKey) {
        ReadOnlyBinaryRangeTree tree = (ReadOnlyBinaryRangeTree)map.get(key);
        return this.getValue(tree, treeKey);
    }

    protected Object getValue(ReadOnlyBinaryRangeTree tree, Comparable[] keys) {
        return this.getValue(tree, keys, 0);
    }

    private Object getValue(ReadOnlyBinaryRangeTree tree, Comparable[] keys, int level) {
        if (tree == null) {
            return null;
        }
        Object value = tree.getValue(keys[level]);
        if (value == null || level == keys.length - 1) {
            return value;
        }
        return this.getValue((ReadOnlyBinaryRangeTree)value, keys, ++level);
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        Iterator it = this.rows.iterator();
        for (int i = 0; it.hasNext() && i < 10; ++i) {
            if (i != 0) {
                output.append("\n");
            }
            output.append(it.next().toString());
        }
        return output.toString();
    }
}

