/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.Serializable;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.internal.RuntimeObject;
import org.faktorips.valueset.IntegerRange;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductComponentLink<E extends IProductComponent>
extends RuntimeObject
implements IProductComponentLink<E> {
    private final IProductComponentGeneration source;
    private IntegerRange cardinality;
    private String targetId;
    private String associationName;
    public static final IntegerRange CARDINALITY_FULL_RANGE = new IntegerRange(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
    public static final IntegerRange CARDINALITY_OPTIONAL = new IntegerRange(Integer.valueOf(0), Integer.valueOf(1));
    public static final IntegerRange CARDINALITY_OBLIGATORY = new IntegerRange(Integer.valueOf(1), Integer.valueOf(1));

    public ProductComponentLink(IProductComponentGeneration source) {
        this.source = source;
    }

    public ProductComponentLink(IProductComponentGeneration source, E target) {
        this(source, target, CARDINALITY_FULL_RANGE);
    }

    public ProductComponentLink(IProductComponentGeneration source, E target, IntegerRange cardinality) {
        if (source == null) {
            throw new NullPointerException("The source for the ProductComponentLink may not be null.");
        }
        this.source = source;
        if (target == null) {
            throw new NullPointerException("The targetId for the ProductComponentLink may not be null.");
        }
        this.targetId = target.getId();
        if (cardinality == null) {
            throw new NullPointerException("The cardinality for the ProductComponentLink may not be null.");
        }
        this.cardinality = cardinality;
    }

    @Override
    public IntegerRange getCardinality() {
        return this.cardinality;
    }

    @Override
    public void initFromXml(Element element) {
        this.associationName = element.getAttribute("association");
        this.targetId = element.getAttribute("targetRuntimeId");
        String maxStr = element.getAttribute("maxCardinality");
        Integer maxCardinality = null;
        maxCardinality = "*".equals(maxStr) || "n".equals(maxStr.toLowerCase()) ? new Integer(Integer.MAX_VALUE) : Integer.valueOf(maxStr);
        Integer minCardinality = Integer.valueOf(element.getAttribute("minCardinality"));
        this.cardinality = new IntegerRange(minCardinality, maxCardinality);
        this.initExtensionPropertiesFromXml(element);
    }

    @Override
    public E getTarget() {
        try {
            return (E)this.source.getRepository().getExistingProductComponent(this.targetId);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    public String getAssociationName() {
        return this.associationName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.targetId);
        sb.append('(');
        sb.append(this.cardinality.getLowerBound());
        sb.append("..");
        sb.append(new Integer(Integer.MAX_VALUE).equals(this.cardinality.getUpperBound()) ? "*" : (Serializable)((Object)this.cardinality.getUpperBound()));
        sb.append(')');
        return sb.toString();
    }

    @Override
    public IProductComponentGeneration getSource() {
        return this.source;
    }
}

