/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.faktorips.runtime.IClRepositoryObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.RuntimeObject;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.valueset.IntegerRange;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProductComponentGeneration
extends RuntimeObject
implements IProductComponentGeneration,
IClRepositoryObject {
    private ProductComponent productCmpt;
    private DateTime validFrom;
    private IFormulaEvaluator formulaEvaluator;

    public ProductComponentGeneration(ProductComponent productCmpt) {
        this.productCmpt = productCmpt;
    }

    @Override
    public final IProductComponent getProductComponent() {
        return this.productCmpt;
    }

    @Override
    public final IProductComponentGeneration getPreviousGeneration() {
        return this.getRepository().getPreviousProductComponentGeneration(this);
    }

    @Override
    public final IProductComponentGeneration getNextGeneration() {
        return this.getRepository().getNextProductComponentGeneration(this);
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.productCmpt.getRepository();
    }

    public final long getValidFromInMillisec(TimeZone zone) {
        return this.validFrom.toDate(zone).getTime();
    }

    @Override
    public final Date getValidFrom(TimeZone zone) {
        return this.validFrom.toDate(zone);
    }

    public void setValidFrom(DateTime newValidFrom) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (newValidFrom == null) {
            throw new NullPointerException();
        }
        this.validFrom = newValidFrom;
    }

    public IFormulaEvaluator getFormulaEvaluator() {
        return this.formulaEvaluator;
    }

    @Override
    public final void initFromXml(Element genElement) {
        if (this.validFrom != null && this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.validFrom = DateTime.parseIso(genElement.getAttribute("validFrom"));
        Map<String, Element> propertyElements = this.getPropertyElements(genElement);
        this.doInitPropertiesFromXml(propertyElements);
        this.doInitTableUsagesFromXml(propertyElements);
        this.doInitReferencesFromXml(this.getLinkElements(genElement));
        this.doInitFormulaFromXml(genElement);
    }

    protected void doInitPropertiesFromXml(Map<String, Element> map) {
    }

    protected void doInitReferencesFromXml(Map<String, List<Element>> map) {
    }

    protected void doInitTableUsagesFromXml(Map<String, Element> map) {
    }

    protected void doInitFormulaFromXml(Element genElement) {
        IFormulaEvaluatorFactory factory;
        if (this.getRepository() != null && (factory = this.getRepository().getFormulaEvaluatorFactory()) != null) {
            ArrayList<String> expressions = new ArrayList<String>();
            NodeList formulas = genElement.getElementsByTagName("Formula");
            for (int i = 0; i < formulas.getLength(); ++i) {
                Element aFormula = (Element)formulas.item(i);
                String name = aFormula.getAttribute("formulaSignature");
                NodeList nodeList = aFormula.getElementsByTagName("compiledExpression");
                if (nodeList.getLength() != 1) {
                    throw new RuntimeException("Expression for Formula: " + name + " not found");
                }
                Element expression = (Element)nodeList.item(0);
                String formulaExpression = expression.getTextContent();
                expressions.add(formulaExpression);
            }
            this.formulaEvaluator = factory.createFormulaEvaluator(this, expressions);
        }
    }

    final Map<String, Element> getPropertyElements(Element genElement) {
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        NodeList nl = genElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element childElement;
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            if ("ConfigElement".equals(node.getNodeName())) {
                childElement = (Element)nl.item(i);
                elementMap.put(childElement.getAttribute("attribute"), childElement);
                continue;
            }
            if ("AttributeValue".equals(node.getNodeName())) {
                childElement = (Element)nl.item(i);
                elementMap.put(childElement.getAttribute("attribute"), childElement);
                continue;
            }
            if (!"TableContentUsage".equals(node.getNodeName())) continue;
            childElement = (Element)nl.item(i);
            String structureUsage = childElement.getAttribute("structureUsage");
            elementMap.put(structureUsage, childElement);
        }
        return elementMap;
    }

    final Map<String, List<Element>> getLinkElements(Element genElement) {
        HashMap<String, List<Element>> elementMap = new HashMap<String, List<Element>>();
        NodeList nl = genElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !"Link".equals(node.getNodeName())) continue;
            Element childElement = (Element)nl.item(i);
            String association = childElement.getAttribute("association");
            ArrayList<Element> associationElements = (ArrayList<Element>)elementMap.get(association);
            if (associationElements == null) {
                associationElements = new ArrayList<Element>(1);
                elementMap.put(association, associationElements);
            }
            associationElements.add(childElement);
        }
        return elementMap;
    }

    protected Element getRangeElement(Element configElement) {
        Element valueSetElement = this.getValueSetElement(configElement);
        return XmlUtil.getFirstElement(valueSetElement, "Range");
    }

    protected NodeList getEnumNodeList(Element configElement) {
        Element enumElement = this.getEnumElement(configElement);
        NodeList nl = enumElement.getElementsByTagName("Value");
        return nl;
    }

    private Element getEnumElement(Element configElement) {
        Element valueSetElement = this.getValueSetElement(configElement);
        return XmlUtil.getFirstElement(valueSetElement, "Enum");
    }

    private Element getValueSetElement(Element configElement) {
        if (configElement == null) {
            throw new NullPointerException();
        }
        Element valueSetElement = XmlUtil.getFirstElement(configElement, "ValueSet");
        if (valueSetElement == null) {
            throw new NullPointerException();
        }
        return valueSetElement;
    }

    public static void addToCardinalityMap(Map<String, IntegerRange> cardinalityMap, String targetId, Element relationElement) {
        String maxStr = relationElement.getAttribute("maxCardinality");
        Integer maxCardinality = null;
        maxCardinality = "*".equals(maxStr) || "n".equals(maxStr.toLowerCase()) ? new Integer(Integer.MAX_VALUE) : Integer.valueOf(maxStr);
        Integer minCardinality = Integer.valueOf(relationElement.getAttribute("minCardinality"));
        cardinalityMap.put(targetId, new IntegerRange(minCardinality, maxCardinality));
    }

    public String toString() {
        return this.getProductComponent().getId() + "-" + this.validFrom;
    }

    protected void setProductCmpt(ProductComponent productCmpt) {
        this.productCmpt = productCmpt;
    }

    @Override
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        throw new RuntimeException("Not implemented yet.");
    }
}

