/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Calendar;
import org.faktorips.runtime.IClRepositoryObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.RuntimeObject;
import org.w3c.dom.Element;

public abstract class ProductComponent
extends RuntimeObject
implements IProductComponent,
IClRepositoryObject {
    private String id;
    private transient IRuntimeRepository repository;
    private String productKindId;
    private String versionId;
    private DateTime validTo;

    public ProductComponent(IRuntimeRepository repository, String id, String productKindId, String versionId) {
        if (repository == null) {
            throw new NullPointerException("RuntimeRepositor was null!");
        }
        if (id == null) {
            throw new NullPointerException("Id was null!");
        }
        if (productKindId == null) {
            throw new NullPointerException("ProductKindId was null");
        }
        if (versionId == null) {
            throw new NullPointerException("VersionId was null");
        }
        this.repository = repository;
        this.id = id;
        this.productKindId = productKindId;
        this.versionId = versionId;
    }

    public String getKindId() {
        return this.productKindId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public final String getId() {
        return this.id;
    }

    public DateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(DateTime validTo) {
        this.validTo = validTo;
    }

    public final IRuntimeRepository getRepository() {
        return this.repository;
    }

    public final IProductComponentGeneration getGenerationBase(Calendar effectiveDate) {
        return this.repository.getProductComponentGeneration(this.id, effectiveDate);
    }

    public IProductComponentGeneration getLatestProductComponentGeneration() {
        return this.getRepository().getLatestProductComponentGeneration(this);
    }

    public final void initFromXml(Element cmptElement) {
        this.validTo = DateTime.parseIso(cmptElement.getAttribute("validTo"));
        this.initExtensionPropertiesFromXml(cmptElement);
    }

    public String toString() {
        return this.id;
    }
}

