/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSaxHandler
extends DefaultHandler {
    private static final String ENUM_VALUE_NAME = "EnumValue";
    private static final String ENUM_ATTRIBUTE_VALUE_NAME = "EnumAttributeValue";
    private List<List<String>> enumValues = new ArrayList<List<String>>();
    private List<String> enumAttributeValues;
    private boolean nextAttributeValue = false;
    private StringBuilder enumValue = new StringBuilder();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (ENUM_VALUE_NAME.equals(qName)) {
            this.enumAttributeValues = new ArrayList<String>();
            return;
        }
        if (ENUM_ATTRIBUTE_VALUE_NAME.equals(qName)) {
            this.nextAttributeValue = true;
            this.enumValue.setLength(0);
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ENUM_VALUE_NAME.equals(qName)) {
            this.enumValues.add(this.enumAttributeValues);
            this.enumAttributeValues = null;
            return;
        }
        if (ENUM_ATTRIBUTE_VALUE_NAME.equals(qName)) {
            this.nextAttributeValue = false;
            this.enumAttributeValues.add(this.enumValue.toString());
            return;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.nextAttributeValue) {
            if (this.enumAttributeValues == null) {
                throw new SAXException("The xml content for this enumeration is not valid. Encountered a tag \"EnumAttributeValue\" that is not embedded in a tag \"EnumAttributeValue\"");
            }
            this.enumValue.append(new String(buf).substring(offset, offset + len));
        }
    }

    public List<List<String>> getEnumValueList() {
        return this.enumValues;
    }
}

