/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntimeRepositoryManager
implements IRuntimeRepositoryManager {
    private volatile IRuntimeRepository actualRuntimeRepository;
    private List<IRuntimeRepositoryManager> managers = new CopyOnWriteArrayList<IRuntimeRepositoryManager>();
    private volatile List<IRuntimeRepositoryManager> allManagers;

    @Override
    public synchronized IRuntimeRepository getActualRuntimeRepository() {
        if (!this.isRepositoryUpToDate(this.actualRuntimeRepository) || !this.isReferencedRepositorysUpToDate()) {
            this.actualRuntimeRepository = this.createNewRuntimeRepository();
            for (IRuntimeRepositoryManager manager : this.managers) {
                this.actualRuntimeRepository.addDirectlyReferencedRepository(manager.getActualRuntimeRepository());
            }
        }
        return this.actualRuntimeRepository;
    }

    protected abstract boolean isRepositoryUpToDate(IRuntimeRepository var1);

    protected abstract IRuntimeRepository createNewRuntimeRepository();

    private boolean isReferencedRepositorysUpToDate() {
        ArrayList<IRuntimeRepository> directReferencedRepos = new ArrayList<IRuntimeRepository>(this.actualRuntimeRepository.getDirectlyReferencedRepositories());
        for (IRuntimeRepositoryManager manager : this.managers) {
            IRuntimeRepository referencedRepository = manager.getActualRuntimeRepository();
            if (directReferencedRepos.remove(referencedRepository)) continue;
            return false;
        }
        return directReferencedRepos.isEmpty();
    }

    @Override
    public final void addDirectlyReferencedManager(IRuntimeRepositoryManager manager) {
        this.allManagers = null;
        this.managers.add(manager);
    }

    @Override
    public List<IRuntimeRepositoryManager> getDirectlyReferencedRepositoryManagers() {
        return Collections.unmodifiableList(this.managers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IRuntimeRepositoryManager> getAllReferencedRepositoryManagers() {
        List<IRuntimeRepositoryManager> result = this.allManagers;
        if (result == null) {
            AbstractRuntimeRepositoryManager abstractRuntimeRepositoryManager = this;
            synchronized (abstractRuntimeRepositoryManager) {
                result = this.allManagers;
                if (result == null) {
                    result = new ArrayList<IRuntimeRepositoryManager>(this.managers.size());
                    LinkedList<IRuntimeRepositoryManager> candidates = new LinkedList<IRuntimeRepositoryManager>();
                    candidates.add(this);
                    while (!candidates.isEmpty()) {
                        IRuntimeRepositoryManager candidate = (IRuntimeRepositoryManager)candidates.get(0);
                        candidates.remove(0);
                        if (candidate != this && !result.contains(candidate)) {
                            result.add(candidate);
                        }
                        for (IRuntimeRepositoryManager newCandidate : candidate.getDirectlyReferencedRepositoryManagers()) {
                            candidates.add(newCandidate);
                        }
                    }
                    this.allManagers = Collections.unmodifiableList(result);
                }
            }
        }
        return this.allManagers;
    }
}

