/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.caching;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.faktorips.runtime.caching.IComputable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Memoizer<K, V>
implements IComputable<K, V> {
    private final ConcurrentMap<K, Future<SoftValue<V>>> cache;
    private final IComputable<K, V> computable;
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public Memoizer(IComputable<K, V> computable) {
        this.computable = computable;
        this.cache = new ConcurrentHashMap<K, Future<SoftValue<V>>>();
    }

    public Memoizer(IComputable<K, V> computable, int initSize, float loadFactor, int concurrencyLevel) {
        this.computable = computable;
        this.cache = new ConcurrentHashMap<K, Future<SoftValue<V>>>(initSize, loadFactor, concurrencyLevel);
    }

    /*
     * Loose catch block
     */
    @Override
    public V compute(final K key) throws InterruptedException {
        while (true) {
            FutureTask future;
            if ((future = (FutureTask)this.cache.get(key)) == null) {
                Callable eval = new Callable<SoftValue<V>>(){

                    @Override
                    public SoftValue<V> call() throws Exception {
                        return new SoftValue(key, Memoizer.this.computable.compute(key), Memoizer.this.queue);
                    }
                };
                FutureTask futureTask = new FutureTask(eval);
                this.processQueue();
                future = this.cache.putIfAbsent(key, futureTask);
                if (future == null) {
                    future = futureTask;
                    futureTask.run();
                }
            }
            try {
                SoftValue softValue = (SoftValue)future.get();
                if (softValue.get() != null) {
                    return (V)softValue.get();
                }
                this.cache.remove(softValue.key);
                return (V)((SoftValue)future.get()).get();
            }
            catch (CancellationException e) {
                this.cache.remove(key, future);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw Memoizer.launderThrowable(e.getCause());
        }
    }

    private void processQueue() {
        Reference<V> ref;
        while ((ref = this.queue.poll()) != null) {
            SoftValue sv = (SoftValue)ref;
            this.cache.remove(sv.key);
        }
    }

    public static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked", t);
    }

    @Override
    public Class<? super V> getValueClass() {
        return this.computable.getValueClass();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValue<V>
    extends SoftReference<V> {
        private final Object key;

        private SoftValue(Object key, V referent, ReferenceQueue<V> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

