/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.faktorips.runtime.MsgReplacementParameter;
import org.faktorips.runtime.ObjectProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
implements Serializable {
    private static final long serialVersionUID = 7155891629458031466L;
    public static final Severity NONE = Severity.NONE;
    public static final Severity INFO = Severity.INFO;
    public static final Severity WARNING = Severity.WARNING;
    public static final Severity ERROR = Severity.ERROR;
    private Severity severity = Severity.ERROR;
    private String text = "";
    private String code = "";
    private List<ObjectProperty> invalidOp = null;
    private List<MsgReplacementParameter> replacementParameters = null;

    public static final Message createCopy(Message msg, Object oldObject, Object newObject) {
        List<ObjectProperty> op = msg.getInvalidObjectProperties();
        ArrayList<ObjectProperty> newOp = new ArrayList<ObjectProperty>(op.size());
        for (ObjectProperty objectProperty : op) {
            if (objectProperty.getObject() == oldObject) {
                newOp.add(new ObjectProperty(newObject, objectProperty.getProperty()));
                continue;
            }
            newOp.add(objectProperty);
        }
        return new Message(msg.code, msg.text, msg.severity, newOp, msg.getReplacementParameters());
    }

    public static final Message newInfo(String code, String text) {
        return new Message(code, text, Severity.INFO);
    }

    public static final Message newWarning(String code, String text) {
        return new Message(code, text, Severity.WARNING);
    }

    public static final Message newError(String code, String text) {
        return new Message(code, text, Severity.ERROR);
    }

    public Message(Message msg) {
        this.code = msg.code;
        this.severity = msg.severity;
        this.text = msg.text;
        if (msg.invalidOp != null) {
            this.invalidOp = new ArrayList<ObjectProperty>();
            this.invalidOp.addAll(msg.invalidOp);
        }
        if (msg.replacementParameters != null) {
            this.replacementParameters = new ArrayList<MsgReplacementParameter>();
            this.replacementParameters.addAll(msg.replacementParameters);
        }
    }

    public Message(String code, String text, Severity severity) {
        this.code = code;
        this.text = text;
        this.severity = severity;
    }

    public Message(String code, String text, Severity severity, ObjectProperty invalidObjectProperty) {
        this(code, text, severity, new ObjectProperty[]{invalidObjectProperty});
    }

    public Message(String code, String text, Severity severity, Object invalidObject) {
        this(code, text, severity, new ObjectProperty(invalidObject, null));
    }

    public Message(String code, String text, Severity severity, Object invalidObject, String ... invalidProperties) {
        this(code, text, severity);
        this.invalidOp = new ArrayList<ObjectProperty>(invalidProperties.length);
        for (String invalidProperty : invalidProperties) {
            this.invalidOp.add(new ObjectProperty(invalidObject, invalidProperty));
        }
    }

    public Message(String code, String text, Severity severity, ObjectProperty[] refersTo) {
        this(code, text, severity);
        if (refersTo != null) {
            this.invalidOp = new ArrayList<ObjectProperty>();
            this.invalidOp.addAll(Arrays.asList(refersTo));
        }
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> refersTo) {
        this(code, text, severity, refersTo, (List<MsgReplacementParameter>)null);
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> refersTo, List<MsgReplacementParameter> replacementParameters) {
        this(code, text, severity);
        if (refersTo != null) {
            this.invalidOp = new ArrayList<ObjectProperty>(refersTo);
        }
        if (replacementParameters != null) {
            this.replacementParameters = new ArrayList<MsgReplacementParameter>(replacementParameters);
        }
    }

    public Message(String code, String text, Severity severity, ObjectProperty refersTo, MsgReplacementParameter ... parameters) {
        this(code, text, severity);
        if (refersTo != null) {
            this.invalidOp = new ArrayList<ObjectProperty>(1);
            this.invalidOp.add(refersTo);
        }
        if (parameters != null) {
            this.replacementParameters = Arrays.asList(parameters);
        }
    }

    public Message(String code, String text, Severity severity, ObjectProperty[] refersTo, MsgReplacementParameter[] parameters) {
        this(code, text, severity);
        if (refersTo != null) {
            this.invalidOp = new ArrayList<ObjectProperty>(1);
            this.invalidOp.addAll(Arrays.asList(refersTo));
        }
        if (parameters != null) {
            this.replacementParameters = Arrays.asList(parameters);
        }
    }

    public Message(String code, String text, Severity severity, ObjectProperty refersTo, List<MsgReplacementParameter> parameters) {
        this(code, text, severity);
        if (refersTo != null) {
            this.invalidOp = new ArrayList<ObjectProperty>(1);
            this.invalidOp.add(refersTo);
        }
        if (parameters != null) {
            this.replacementParameters = new ArrayList<MsgReplacementParameter>(parameters);
        }
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public String getCode() {
        return this.code;
    }

    public int getNumOfInvalidObjectProperties() {
        if (this.invalidOp == null) {
            return 0;
        }
        return this.invalidOp.size();
    }

    public List<ObjectProperty> getInvalidObjectProperties() {
        if (this.invalidOp == null) {
            return new ArrayList<ObjectProperty>(0);
        }
        return Collections.unmodifiableList(this.invalidOp);
    }

    public int getNumOfReplacementParameters() {
        if (this.replacementParameters == null) {
            return 0;
        }
        return this.replacementParameters.size();
    }

    public List<MsgReplacementParameter> getReplacementParameters() {
        if (this.replacementParameters == null) {
            return new ArrayList<MsgReplacementParameter>(0);
        }
        return this.replacementParameters;
    }

    public boolean hasReplacementParameter(String paramName) {
        if (this.replacementParameters == null) {
            return false;
        }
        for (MsgReplacementParameter replacementParameter : this.replacementParameters) {
            if (!replacementParameter.getName().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    public Object getReplacementValue(String paramName) {
        if (this.replacementParameters == null) {
            return null;
        }
        for (MsgReplacementParameter replacementParameter : this.replacementParameters) {
            if (!replacementParameter.getName().equals(paramName)) continue;
            return replacementParameter.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        switch (this.severity) {
            case ERROR: {
                buffer.append("ERROR");
                break;
            }
            case WARNING: {
                buffer.append("WARNING ");
                break;
            }
            case INFO: {
                buffer.append("INFO");
                break;
            }
            default: {
                buffer.append("Severity ");
                buffer.append((Object)this.severity);
            }
        }
        buffer.append(' ');
        buffer.append(this.code);
        buffer.append('[');
        String lineSeparator = System.getProperty("line.separator");
        int max = this.invalidOp == null ? 0 : this.invalidOp.size();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.invalidOp.get(i).getObject().toString());
            buffer.append('.');
            buffer.append(this.invalidOp.get(i).getProperty());
        }
        buffer.append(']');
        buffer.append(lineSeparator);
        buffer.append(this.text);
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!this.code.equals(other.code) || this.severity != other.severity || !this.text.equals(other.text)) {
            return false;
        }
        int numOfInvalidObjectProperties = this.getNumOfInvalidObjectProperties();
        if (numOfInvalidObjectProperties != other.getNumOfInvalidObjectProperties()) {
            return false;
        }
        if (this.invalidOp == null) {
            return other.invalidOp == null;
        }
        if (!((Object)this.invalidOp).equals(other.invalidOp)) {
            return false;
        }
        int numOfReplacementParams = this.getNumOfReplacementParameters();
        if (numOfReplacementParams != other.getNumOfReplacementParameters()) {
            return false;
        }
        if (this.replacementParameters == null) {
            return other.replacementParameters == null;
        }
        return ((Object)this.replacementParameters).equals(other.replacementParameters);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        NONE,
        INFO,
        WARNING,
        ERROR;

    }
}

