/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.faktorips.runtime.AssociationChangedEvent;

public class IpsPropertyChangeSupport
extends PropertyChangeSupport {
    private static final long serialVersionUID = -236185652576376253L;
    private final Object sourceBean;
    private Vector<PropertyChangeListener> childChangeListeners;

    public IpsPropertyChangeSupport(Object sourceBean) {
        super(sourceBean);
        this.sourceBean = sourceBean;
    }

    public void fireAssociationChange(AssociationChangedEvent evt) {
        Object addedAssociationTarget = evt.getAddedAssociationTarget();
        Object removedAssociationTarget = evt.getRemovedAssociationTarget();
        if (addedAssociationTarget == null && removedAssociationTarget == null) {
            return;
        }
        this.firePropertyChange(evt);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.sourceBean) {
            super.firePropertyChange(evt);
        } else {
            this.fireChildPropertyChange(evt);
        }
    }

    public void fireAssociationAdded(String associationName, Object addedAssociationTarget) {
        if (addedAssociationTarget == null) {
            return;
        }
        this.fireAssociationChange(new AssociationChangedEvent(this.sourceBean, associationName, null, addedAssociationTarget));
    }

    public void fireAssociationRemoved(String associationName, Object removedAssociationTarget) {
        if (removedAssociationTarget == null) {
            return;
        }
        this.fireAssociationChange(new AssociationChangedEvent(this.sourceBean, associationName, removedAssociationTarget, null));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener, boolean propagateEventsFromChildren) {
        super.addPropertyChangeListener(listener);
        if (propagateEventsFromChildren) {
            if (this.childChangeListeners == null) {
                this.childChangeListeners = new Vector();
            }
            this.childChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChildPropertyChange(PropertyChangeEvent evt) {
        List<PropertyChangeListener> targets = null;
        IpsPropertyChangeSupport ipsPropertyChangeSupport = this;
        synchronized (ipsPropertyChangeSupport) {
            if (this.childChangeListeners != null) {
                targets = Collections.unmodifiableList(this.childChangeListeners);
            }
        }
        if (targets != null) {
            for (PropertyChangeListener target : targets) {
                target.propertyChange(evt);
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.childChangeListeners != null && this.childChangeListeners.contains(listener)) {
            this.childChangeListeners.remove(listener);
        }
    }
}

