/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.lang.reflect.Method;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.IUnresolvedReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUnresolvedReference
implements IUnresolvedReference {
    private Object sourceObj;
    private Object sourceObjId;
    private Method establishMethod;
    private Object targetId;
    private Class<?> targetClass;

    public DefaultUnresolvedReference(Object sourceObj, Object sourceObjId, Method establishMethod, Class<?> targetClass, Object targetId) {
        this.sourceObj = sourceObj;
        this.sourceObjId = sourceObjId;
        this.establishMethod = establishMethod;
        this.targetClass = targetClass;
        this.targetId = targetId;
    }

    public DefaultUnresolvedReference(Object sourceObj, Object sourceObjId, String establishMethodName, Class<?> targetClass, Object targetId) {
        this.sourceObj = sourceObj;
        this.sourceObjId = sourceObjId;
        this.targetClass = targetClass;
        this.targetId = targetId;
        try {
            this.establishMethod = sourceObj.getClass().getMethod(establishMethodName, targetClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get method to establish association, sourceClass=" + sourceObj.getClass().getName() + "method=" + establishMethodName + ", targetClass=" + targetClass.getName());
        }
    }

    @Override
    public void resolve(IObjectReferenceStore store) throws Exception {
        Object target = store.getObject(this.targetClass, this.targetId);
        this.establishMethod.invoke(this.sourceObj, target);
    }

    public Method getEstablishMethod() {
        return this.establishMethod;
    }

    public Object getSourceObj() {
        return this.sourceObj;
    }

    public Object getSourceObjId() {
        return this.sourceObjId;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Object getTargetId() {
        return this.targetId;
    }

    public String toString() {
        return "Unresolved reference: From " + this.sourceObj + "(" + this.sourceObjId + ")" + "To: " + this.targetClass + "(" + this.targetId + ")" + "Method to estabalish: " + this.establishMethod;
    }
}

