/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BrokenBarrierException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CyclicBarrier {
    private final Object lock;
    private final int parties;
    private final Runnable barrierCommand;
    private Generation generation;
    private int count;

    private final void nextGeneration() {
        this.lock.notifyAll();
        this.count = this.parties;
        this.generation = new Generation();
    }

    private final void breakBarrier() {
        this.generation.broken = true;
        this.count = this.parties;
        this.lock.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int dowait(boolean timed, long nanos) throws InterruptedException, BrokenBarrierException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            int index;
            Generation g = this.generation;
            if (g.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if ((index = --this.count) == 0) {
                boolean ranAction = false;
                try {
                    Runnable command = this.barrierCommand;
                    if (command != null) {
                        command.run();
                    }
                    ranAction = true;
                    this.nextGeneration();
                    int n = 0;
                    Object var11_10 = null;
                    if (!ranAction) {
                        this.breakBarrier();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (!ranAction) {
                        this.breakBarrier();
                    }
                    throw throwable;
                }
            }
            long deadline = timed ? Utils.nanoTime() + nanos : 0L;
            while (true) {
                block20: {
                    try {
                        if (!timed) {
                            this.lock.wait();
                            break block20;
                        }
                        if (nanos > 0L) {
                            TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                        }
                    }
                    catch (InterruptedException ie) {
                        if (g == this.generation && !g.broken) {
                            this.breakBarrier();
                            throw ie;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                if (g.broken) {
                    throw new BrokenBarrierException();
                }
                if (g != this.generation) {
                    return index;
                }
                if (timed && nanos <= 0L) {
                    this.breakBarrier();
                    throw new TimeoutException();
                }
                nanos = deadline - Utils.nanoTime();
            }
        }
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException toe) {
            throw new Error(toe);
        }
    }

    public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBroken() {
        Object object = this.lock;
        synchronized (object) {
            return this.generation.broken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.breakBarrier();
            this.nextGeneration();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumberWaiting() {
        Object object = this.lock;
        synchronized (object) {
            return this.parties - this.count;
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
        this.generation = new Generation();
    }

    public CyclicBarrier(int parties, Runnable barrierAction) {
        this.this();
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
        this.count = parties;
        this.barrierCommand = barrierAction;
    }

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Generation {
        boolean broken;

        private final /* synthetic */ void this() {
            this.broken = false;
        }

        private Generation() {
            this.this();
        }
    }
}

