/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.command.ActiveMQDestination;

public abstract class ActiveMQTempDestination
extends ActiveMQDestination {
    protected transient ActiveMQConnection connection;
    protected transient String connectionId;
    protected transient int sequenceId;

    public ActiveMQTempDestination() {
    }

    public ActiveMQTempDestination(String name) {
        super(name);
    }

    public ActiveMQTempDestination(String connectionId, long sequenceId) {
        super(connectionId + ":" + sequenceId);
    }

    public boolean isTemporary() {
        return true;
    }

    public void delete() throws JMSException {
        this.connection.deleteTempDestination(this);
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ActiveMQConnection connection) {
        this.connection = connection;
    }

    public void setPhysicalName(String physicalName) {
        super.setPhysicalName(physicalName);
        if (!this.isComposite()) {
            int p = this.physicalName.lastIndexOf(":");
            this.sequenceId = Integer.parseInt(this.physicalName.substring(p + 1).trim());
            this.connectionId = this.physicalName.substring(0, p);
        }
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }
}

