/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.QueueRegion;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TempQueueRegion;
import org.apache.activemq.broker.region.TempTopicRegion;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.broker.region.policy.PendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.ServiceStopper;

public class RegionBroker
implements Broker {
    private static final IdGenerator brokerIdGenerator = new IdGenerator();
    private final Region queueRegion;
    private final Region topicRegion;
    private final Region tempQueueRegion;
    private final Region tempTopicRegion;
    private BrokerService brokerService;
    private boolean stopped = false;
    private boolean keepDurableSubsActive = false;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    private final CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
    private final Map destinations = new ConcurrentHashMap();
    private final CopyOnWriteArrayList brokerInfos = new CopyOnWriteArrayList();
    private final LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    private BrokerId brokerId;
    private String brokerName;
    private Map clientIdSet = new HashMap();
    private final DestinationInterceptor destinationInterceptor;
    private ConnectionContext adminConnectionContext;
    protected DestinationFactory destinationFactory;
    protected final ConcurrentHashMap connectionStates = new ConcurrentHashMap();
    private PendingDurableSubscriberMessageStoragePolicy pendingDurableSubscriberPolicy = new VMPendingDurableSubscriberMessageStoragePolicy();

    public RegionBroker(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, UsageManager memoryManager, DestinationFactory destinationFactory, DestinationInterceptor destinationInterceptor) throws IOException {
        this.brokerService = brokerService;
        if (destinationFactory == null) {
            throw new IllegalArgumentException("null destinationFactory");
        }
        this.sequenceGenerator.setLastSequenceId(destinationFactory.getLastMessageBrokerSequenceId());
        this.destinationFactory = destinationFactory;
        this.queueRegion = this.createQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.topicRegion = this.createTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.destinationInterceptor = destinationInterceptor;
        this.tempQueueRegion = this.createTempQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.tempTopicRegion = this.createTempTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
    }

    public Map getDestinationMap() {
        Map answer = this.getQueueRegion().getDestinationMap();
        answer.putAll(this.getTopicRegion().getDestinationMap());
        return answer;
    }

    public Set getDestinations(ActiveMQDestination destination) {
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.getDestinations(destination);
            }
            case 2: {
                return this.topicRegion.getDestinations(destination);
            }
            case 5: {
                return this.tempQueueRegion.getDestinations(destination);
            }
            case 6: {
                return this.tempTopicRegion.getDestinations(destination);
            }
        }
        return Collections.EMPTY_SET;
    }

    public Broker getAdaptor(Class type) {
        if (type.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Region getQueueRegion() {
        return this.queueRegion;
    }

    public Region getTempQueueRegion() {
        return this.tempQueueRegion;
    }

    public Region getTempTopicRegion() {
        return this.tempTopicRegion;
    }

    public Region getTopicRegion() {
        return this.topicRegion;
    }

    protected Region createTempTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTempQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new QueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    private static PersistenceAdapter createDefaultPersistenceAdapter(UsageManager memoryManager) throws IOException {
        return new MemoryPersistenceAdapter();
    }

    public void start() throws Exception {
        ((TopicRegion)this.topicRegion).setKeepDurableSubsActive(this.keepDurableSubsActive);
        this.queueRegion.start();
        this.topicRegion.start();
        this.tempQueueRegion.start();
        this.tempTopicRegion.start();
    }

    public void stop() throws Exception {
        this.stopped = true;
        ServiceStopper ss = new ServiceStopper();
        this.doStop(ss);
        ss.throwFirstException();
    }

    public PolicyMap getDestinationPolicy() {
        return this.brokerService != null ? this.brokerService.getDestinationPolicy() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        Map map = this.clientIdSet;
        synchronized (map) {
            if (this.clientIdSet.containsKey(clientId)) {
                throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected");
            }
            this.clientIdSet.put(clientId, info);
        }
        this.connections.add((Object)context.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection disconnect request");
        }
        Map map = this.clientIdSet;
        synchronized (map) {
            ConnectionInfo oldValue = (ConnectionInfo)this.clientIdSet.get(clientId);
            if (oldValue != null && this.isEqual(oldValue.getConnectionId(), info.getConnectionId())) {
                this.clientIdSet.remove(clientId);
            }
        }
        this.connections.remove((Object)context.getConnection());
    }

    protected boolean isEqual(ConnectionId connectionId, ConnectionId connectionId2) {
        return connectionId == connectionId2 || connectionId != null && connectionId.equals(connectionId2);
    }

    public Connection[] getClients() throws Exception {
        ArrayList l = new ArrayList(this.connections);
        Connection[] rc = new Connection[l.size()];
        l.toArray(rc);
        return rc;
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        Destination answer = (Destination)this.destinations.get(destination);
        if (answer != null) {
            return answer;
        }
        switch (destination.getDestinationType()) {
            case 1: {
                answer = this.queueRegion.addDestination(context, destination);
                break;
            }
            case 2: {
                answer = this.topicRegion.addDestination(context, destination);
                break;
            }
            case 5: {
                answer = this.tempQueueRegion.addDestination(context, destination);
                break;
            }
            case 6: {
                answer = this.tempTopicRegion.addDestination(context, destination);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
        this.destinations.put(destination, answer);
        return answer;
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (this.destinations.remove(destination) != null) {
            switch (destination.getDestinationType()) {
                case 1: {
                    this.queueRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 2: {
                    this.topicRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 5: {
                    this.tempQueueRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 6: {
                    this.tempTopicRegion.removeDestination(context, destination, timeout);
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
        }
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.addDestination(context, info.getDestination());
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.removeDestination(context, info.getDestination(), info.getTimeout());
    }

    public ActiveMQDestination[] getDestinations() throws Exception {
        ArrayList l = new ArrayList(this.destinations.values());
        ActiveMQDestination[] rc = new ActiveMQDestination[l.size()];
        l.toArray(rc);
        return rc;
    }

    public void addSession(ConnectionContext context, SessionInfo info) throws Exception {
    }

    public void removeSession(ConnectionContext context, SessionInfo info) throws Exception {
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.addConsumer(context, info);
            }
            case 2: {
                return this.topicRegion.addConsumer(context, info);
            }
            case 5: {
                return this.tempQueueRegion.addConsumer(context, info);
            }
            case 6: {
                return this.tempTopicRegion.addConsumer(context, info);
            }
        }
        throw this.createUnknownDestinationTypeException(destination);
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.removeConsumer(context, info);
                break;
            }
            case 2: {
                this.topicRegion.removeConsumer(context, info);
                break;
            }
            case 5: {
                this.tempQueueRegion.removeConsumer(context, info);
                break;
            }
            case 6: {
                this.tempTopicRegion.removeConsumer(context, info);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        this.topicRegion.removeSubscription(context, info);
    }

    public void send(ConnectionContext context, Message message) throws Exception {
        message.getMessageId().setBrokerSequenceId(this.sequenceGenerator.getNextSequenceId());
        ActiveMQDestination destination = message.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.send(context, message);
                break;
            }
            case 2: {
                this.topicRegion.send(context, message);
                break;
            }
            case 5: {
                this.tempQueueRegion.send(context, message);
                break;
            }
            case 6: {
                this.tempTopicRegion.send(context, message);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        ActiveMQDestination destination = ack.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.acknowledge(context, ack);
                break;
            }
            case 2: {
                this.topicRegion.acknowledge(context, ack);
                break;
            }
            case 5: {
                this.tempQueueRegion.acknowledge(context, ack);
                break;
            }
            case 6: {
                this.tempTopicRegion.acknowledge(context, ack);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        ActiveMQDestination destination = pull.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.messagePull(context, pull);
            }
            case 2: {
                return this.topicRegion.messagePull(context, pull);
            }
            case 5: {
                return this.tempQueueRegion.messagePull(context, pull);
            }
            case 6: {
                return this.tempTopicRegion.messagePull(context, pull);
            }
        }
        throw this.createUnknownDestinationTypeException(destination);
    }

    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void gc() {
        this.queueRegion.gc();
        this.topicRegion.gc();
    }

    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(brokerIdGenerator.generateId());
        }
        return this.brokerId;
    }

    public void setBrokerId(BrokerId brokerId) {
        this.brokerId = brokerId;
    }

    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddress.getLocalHost().getHostName().toLowerCase();
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    protected JMSException createUnknownDestinationTypeException(ActiveMQDestination destination) {
        return new JMSException("Unknown destination type: " + destination.getDestinationType());
    }

    public synchronized void addBroker(Connection connection, BrokerInfo info) {
        this.brokerInfos.add((Object)info);
    }

    public synchronized void removeBroker(Connection connection, BrokerInfo info) {
        if (info != null) {
            this.brokerInfos.remove((Object)info);
        }
    }

    public synchronized BrokerInfo[] getPeerBrokerInfos() {
        Object[] result = new BrokerInfo[this.brokerInfos.size()];
        result = (BrokerInfo[])this.brokerInfos.toArray(result);
        return result;
    }

    public void processDispatch(MessageDispatch messageDispatch) {
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        ActiveMQDestination destination = messageDispatchNotification.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 2: {
                this.topicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 5: {
                this.tempQueueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 6: {
                this.tempTopicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public boolean isSlaveBroker() {
        return this.brokerService.isSlave();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Set getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    public boolean isFaultTolerantConfiguration() {
        return false;
    }

    protected void doStop(ServiceStopper ss) {
        ss.stop(this.queueRegion);
        ss.stop(this.topicRegion);
        ss.stop(this.tempQueueRegion);
        ss.stop(this.tempTopicRegion);
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
    }

    public DestinationInterceptor getDestinationInterceptor() {
        return this.destinationInterceptor;
    }

    public ConnectionContext getAdminConnectionContext() {
        return this.adminConnectionContext;
    }

    public void setAdminConnectionContext(ConnectionContext adminConnectionContext) {
        this.adminConnectionContext = adminConnectionContext;
    }

    public Map getConnectionStates() {
        return this.connectionStates;
    }

    public Store getTempDataStore() {
        return this.brokerService.getTempDataStore();
    }

    public PendingDurableSubscriberMessageStoragePolicy getPendingDurableSubscriberPolicy() {
        return this.pendingDurableSubscriberPolicy;
    }

    public void setPendingDurableSubscriberPolicy(PendingDurableSubscriberMessageStoragePolicy durableSubscriberCursor) {
        this.pendingDurableSubscriberPolicy = durableSubscriberCursor;
    }
}

