/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.InsertableMutableBrokerFilter;
import org.apache.activemq.broker.MutableBrokerFilter;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterBroker
extends InsertableMutableBrokerFilter {
    private static final Log log = LogFactory.getLog((Class)MasterBroker.class);
    private Transport slave;
    private AtomicBoolean started = new AtomicBoolean(false);

    public MasterBroker(MutableBrokerFilter parent, Transport slave) {
        super(parent);
        this.slave = slave;
    }

    public void startProcessing() {
        this.started.set(true);
        try {
            Connection[] connections = this.getClients();
            ConnectionControl command = new ConnectionControl();
            command.setFaultTolerant(true);
            if (connections != null) {
                for (int i = 0; i < connections.length; ++i) {
                    if (!connections[i].isActive() || !connections[i].isManageable()) continue;
                    connections[i].dispatchAsync(command);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get Connections", (Throwable)e);
        }
    }

    public void stop() throws Exception {
        super.stop();
        this.stopProcessing();
    }

    public void stopProcessing() {
        if (this.started.compareAndSet(true, false)) {
            this.remove();
        }
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        super.addConnection(context, info);
        this.sendAsyncToSlave(info);
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        this.sendAsyncToSlave(new RemoveInfo(info.getConnectionId()));
    }

    public void addSession(ConnectionContext context, SessionInfo info) throws Exception {
        super.addSession(context, info);
        this.sendAsyncToSlave(info);
    }

    public void removeSession(ConnectionContext context, SessionInfo info) throws Exception {
        super.removeSession(context, info);
        this.sendAsyncToSlave(new RemoveInfo(info.getSessionId()));
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.addProducer(context, info);
        this.sendAsyncToSlave(info);
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.removeProducer(context, info);
        this.sendAsyncToSlave(new RemoveInfo(info.getProducerId()));
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        this.sendAsyncToSlave(info);
        Subscription answer = super.addConsumer(context, info);
        return answer;
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        super.removeSubscription(context, info);
        this.sendAsyncToSlave(info);
    }

    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 0);
        this.sendAsyncToSlave(info);
        super.beginTransaction(context, xid);
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 1);
        this.sendAsyncToSlave(info);
        int result = super.prepareTransaction(context, xid);
        return result;
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 4);
        this.sendAsyncToSlave(info);
        super.rollbackTransaction(context, xid);
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 2);
        this.sendSyncToSlave(info);
        super.commitTransaction(context, xid, onePhase);
    }

    public void forgetTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 6);
        this.sendAsyncToSlave(info);
        super.forgetTransaction(context, xid);
    }

    public void processDispatch(MessageDispatch messageDispatch) {
        MessageDispatchNotification mdn = new MessageDispatchNotification();
        mdn.setConsumerId(messageDispatch.getConsumerId());
        mdn.setDeliverySequenceId(messageDispatch.getDeliverySequenceId());
        mdn.setDestination(messageDispatch.getDestination());
        if (messageDispatch.getMessage() != null) {
            mdn.setMessageId(messageDispatch.getMessage().getMessageId());
        }
        this.sendAsyncToSlave(mdn);
        super.processDispatch(messageDispatch);
    }

    public void send(ConnectionContext context, Message message) throws Exception {
        this.sendToSlave(message);
        super.send(context, message);
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        this.sendToSlave(ack);
        super.acknowledge(context, ack);
    }

    public boolean isFaultTolerantConfiguration() {
        return true;
    }

    protected void sendToSlave(Message message) {
        if (message.isResponseRequired()) {
            this.sendSyncToSlave(message);
        } else {
            this.sendAsyncToSlave(message);
        }
    }

    protected void sendToSlave(MessageAck ack) {
        if (ack.isResponseRequired()) {
            this.sendAsyncToSlave(ack);
        } else {
            this.sendSyncToSlave(ack);
        }
    }

    protected void sendAsyncToSlave(Command command) {
        try {
            this.slave.oneway(command);
        }
        catch (Throwable e) {
            log.error((Object)"Slave Failed", e);
            this.stopProcessing();
        }
    }

    protected void sendSyncToSlave(Command command) {
        try {
            Response response = (Response)this.slave.request(command);
            if (response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                log.error((Object)"Slave Failed", er.getException());
            }
        }
        catch (Throwable e) {
            log.error((Object)"Slave Failed", e);
        }
    }
}

