/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.loader.Options;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MulticastDiscoveryAgent
implements DiscoveryAgent,
ServerService,
SelfManaging {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery"), MulticastDiscoveryAgent.class);
    private static final int BUFF_SIZE = 8192;
    private AtomicBoolean started = new AtomicBoolean(false);
    private MulticastSocket multicast;
    private String host = "239.255.3.2";
    private int port = 6142;
    private int timeToLive = 1;
    private boolean loopbackMode = false;
    private SocketAddress address;
    private Map<String, Service> registeredServices = new ConcurrentHashMap<String, Service>();
    private String group = "default";
    private String groupPrefix = this.group + ":";
    private int maxMissedHeartbeats = 10;
    private long heartRate = 500L;
    private Listener listener = new Listener();
    private long reconnectDelay = 5000L;
    private long maxReconnectDelay = 30000L;
    private long exponentialBackoff = 0L;
    private boolean useExponentialBackOff;
    private int maxReconnectAttempts = 10;

    public void init(Properties props) throws Exception {
        this.host = props.getProperty("bind", this.host);
        this.group = props.getProperty("group", this.group);
        this.groupPrefix = this.group + ":";
        Options options = new Options(props);
        this.port = options.get("port", this.port);
        this.heartRate = options.get("heart_rate", this.heartRate);
        this.maxMissedHeartbeats = options.get("max_missed_heartbeats", this.maxMissedHeartbeats);
        this.loopbackMode = options.get("loopback_mode", this.loopbackMode);
        this.reconnectDelay = options.get("reconnect_delay", this.reconnectDelay);
        this.maxReconnectDelay = options.get("max_reconnect_delay", this.reconnectDelay);
        this.maxReconnectAttempts = options.get("max_reconnect_attempts", this.maxReconnectAttempts);
        this.exponentialBackoff = options.get("exponential_backoff", this.exponentialBackoff);
        this.useExponentialBackOff = this.exponentialBackoff > 1L;
    }

    public String getIP() {
        return this.host;
    }

    public String getName() {
        return "multicast";
    }

    public int getPort() {
        return this.port;
    }

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener.setDiscoveryListener(listener);
    }

    public void registerService(URI serviceUri) throws IOException {
        Service service = new Service(serviceUri);
        this.registeredServices.put(service.broadcastString, service);
        this.listener.fireServiceAddedEvent(serviceUri);
    }

    public void unregisterService(URI serviceUri) throws IOException {
        Service service = new Service(serviceUri);
        this.registeredServices.remove(service.broadcastString);
        this.listener.fireServiceRemovedEvent(serviceUri);
    }

    public void reportFailed(URI serviceUri) throws IOException {
        this.listener.reportFailed(serviceUri);
    }

    private boolean isSelf(Service service) {
        return this.isSelf(service.broadcastString);
    }

    private boolean isSelf(String service) {
        return this.registeredServices.keySet().contains(service);
    }

    public static void main(String[] args) throws Exception {
    }

    public void start() throws ServiceException {
        try {
            if (this.started.compareAndSet(false, true)) {
                InetAddress inetAddress = InetAddress.getByName(this.host);
                this.address = new InetSocketAddress(inetAddress, this.port);
                this.multicast = new MulticastSocket(this.port);
                this.multicast.setLoopbackMode(this.loopbackMode);
                this.multicast.setTimeToLive(this.timeToLive);
                this.multicast.joinGroup(inetAddress);
                this.multicast.setSoTimeout((int)this.heartRate);
                Thread listenerThread = new Thread(this.listener);
                listenerThread.setName("MulticastDiscovery: Listener");
                listenerThread.setDaemon(true);
                listenerThread.start();
                Broadcaster broadcaster = new Broadcaster();
                Timer timer = new Timer("MulticastDiscovery: Broadcaster", true);
                timer.scheduleAtFixedRate((TimerTask)broadcaster, 0L, this.heartRate);
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stop() throws ServiceException {
        if (this.started.compareAndSet(true, false)) {
            this.multicast.close();
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public long getExponentialBackoff() {
        return this.exponentialBackoff;
    }

    public void setExponentialBackoff(long exponentialBackoff) {
        this.exponentialBackoff = exponentialBackoff;
        this.useExponentialBackOff = exponentialBackoff > 1L;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
        this.groupPrefix = group + ":";
    }

    public long getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(long heartRate) {
        this.heartRate = heartRate;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public boolean isLoopbackMode() {
        return this.loopbackMode;
    }

    public void setLoopbackMode(boolean loopbackMode) {
        this.loopbackMode = loopbackMode;
    }

    public int getMaxMissedHeartbeats() {
        return this.maxMissedHeartbeats;
    }

    public void setMaxMissedHeartbeats(int maxMissedHeartbeats) {
        this.maxMissedHeartbeats = maxMissedHeartbeats;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    class Broadcaster
    extends TimerTask {
        private IOException failed;

        Broadcaster() {
        }

        public void run() {
            if (MulticastDiscoveryAgent.this.started.get()) {
                this.heartbeat();
            }
        }

        private void heartbeat() {
            for (String uri : MulticastDiscoveryAgent.this.registeredServices.keySet()) {
                try {
                    byte[] data = uri.getBytes();
                    DatagramPacket packet = new DatagramPacket(data, 0, data.length, MulticastDiscoveryAgent.this.address);
                    MulticastDiscoveryAgent.this.multicast.send(packet);
                }
                catch (IOException e) {
                    if (this.failed != null) continue;
                    this.failed = e;
                    log.error("Failed to advertise our service: " + uri, (Throwable)e);
                    if (!"Operation not permitted".equals(e.getMessage())) continue;
                    log.error("The 'Operation not permitted' error has been know to be caused by improper firewall/network setup.  Please make sure that the OS is properly configured to allow multicast traffic over: " + MulticastDiscoveryAgent.this.multicast.getLocalAddress());
                }
            }
        }
    }

    class Listener
    implements Runnable {
        private Map<String, ServiceVitals> discoveredServices = new ConcurrentHashMap<String, ServiceVitals>();
        private DiscoveryListener discoveryListener;
        private final Executor executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "Multicast Discovery Agent Notifier");
                t.setDaemon(true);
                return t;
            }
        });

        Listener() {
        }

        public void setDiscoveryListener(DiscoveryListener discoveryListener) {
            this.discoveryListener = discoveryListener;
        }

        public void run() {
            byte[] buf = new byte[8192];
            DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
            while (MulticastDiscoveryAgent.this.started.get()) {
                this.checkServices();
                try {
                    MulticastDiscoveryAgent.this.multicast.receive(packet);
                    if (packet.getLength() <= 0) continue;
                    String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                    this.processData(str);
                }
                catch (SocketTimeoutException se) {
                }
                catch (IOException e) {
                    if (!MulticastDiscoveryAgent.this.started.get()) continue;
                    log.error("failed to process packet: " + e);
                }
            }
        }

        private void processData(String uriString) {
            if (this.discoveryListener == null) {
                return;
            }
            if (!uriString.startsWith(MulticastDiscoveryAgent.this.groupPrefix)) {
                return;
            }
            if (MulticastDiscoveryAgent.this.isSelf(uriString)) {
                return;
            }
            ServiceVitals vitals = this.discoveredServices.get(uriString);
            if (vitals == null) {
                try {
                    vitals = new ServiceVitals(new Service(uriString));
                    this.discoveredServices.put(uriString, vitals);
                    this.fireServiceAddedEvent(vitals.service.uri);
                }
                catch (URISyntaxException uRISyntaxException) {}
            } else {
                vitals.heartbeat();
                if (vitals.doRecovery()) {
                    this.fireServiceAddedEvent(vitals.service.uri);
                }
            }
        }

        private void checkServices() {
            long expireTime = System.currentTimeMillis() - MulticastDiscoveryAgent.this.heartRate * (long)MulticastDiscoveryAgent.this.maxMissedHeartbeats;
            for (ServiceVitals serviceVitals : this.discoveredServices.values()) {
                ServiceVitals vitals;
                if (serviceVitals.getLastHeartbeat() >= expireTime || MulticastDiscoveryAgent.this.isSelf(serviceVitals.service) || (vitals = this.discoveredServices.remove(serviceVitals.service.broadcastString)) == null || vitals.isDead()) continue;
                this.fireServiceRemovedEvent(vitals.service.uri);
            }
        }

        private void fireServiceRemovedEvent(final URI uri) {
            if (this.discoveryListener != null) {
                final DiscoveryListener discoveryListener = this.discoveryListener;
                this.executor.execute(new Runnable(){

                    public void run() {
                        if (discoveryListener != null) {
                            discoveryListener.serviceRemoved(uri);
                        }
                    }
                });
            }
        }

        private void fireServiceAddedEvent(final URI uri) {
            if (this.discoveryListener != null) {
                final DiscoveryListener discoveryListener = this.discoveryListener;
                this.executor.execute(new Runnable(){

                    public void run() {
                        if (discoveryListener != null) {
                            discoveryListener.serviceAdded(uri);
                        }
                    }
                });
            }
        }

        public void reportFailed(URI serviceUri) {
            Service service = new Service(serviceUri);
            ServiceVitals serviceVitals = this.discoveredServices.get(service.broadcastString);
            if (serviceVitals != null && serviceVitals.pronounceDead()) {
                this.fireServiceRemovedEvent(service.uri);
            }
        }
    }

    private class ServiceVitals {
        private final Service service;
        private long lastHeartBeat;
        private long recoveryTime;
        private int failureCount;
        private boolean dead;

        public ServiceVitals(Service service) {
            this.service = service;
            this.lastHeartBeat = System.currentTimeMillis();
        }

        public synchronized void heartbeat() {
            this.lastHeartBeat = System.currentTimeMillis();
            if (!this.dead && this.failureCount > 0 && this.lastHeartBeat - this.recoveryTime > 60000L) {
                if (log.isDebugEnabled()) {
                    log.debug("I now think that the " + this.service + " service has recovered.");
                }
                this.failureCount = 0;
                this.recoveryTime = 0L;
            }
        }

        public synchronized long getLastHeartbeat() {
            return this.lastHeartBeat;
        }

        public synchronized boolean pronounceDead() {
            if (!this.dead) {
                long delay;
                this.dead = true;
                ++this.failureCount;
                if (MulticastDiscoveryAgent.this.useExponentialBackOff) {
                    delay = (long)Math.pow(MulticastDiscoveryAgent.this.exponentialBackoff, this.failureCount);
                    if (delay > MulticastDiscoveryAgent.this.maxReconnectDelay) {
                        delay = MulticastDiscoveryAgent.this.maxReconnectDelay;
                    }
                } else {
                    delay = MulticastDiscoveryAgent.this.reconnectDelay;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remote failure of " + this.service + " while still receiving multicast advertisements.  " + "Advertising events will be suppressed for " + delay + " ms, the current failure count is: " + this.failureCount);
                }
                this.recoveryTime = System.currentTimeMillis() + delay;
                return true;
            }
            return false;
        }

        public synchronized boolean doRecovery() {
            if (!this.dead) {
                return false;
            }
            if (MulticastDiscoveryAgent.this.maxReconnectAttempts > 0 && this.failureCount > MulticastDiscoveryAgent.this.maxReconnectAttempts) {
                if (log.isDebugEnabled()) {
                    log.debug("Max reconnect attempts of the " + this.service + " service has been reached.");
                }
                return false;
            }
            if (System.currentTimeMillis() < this.recoveryTime) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("Resuming event advertisement of the " + this.service + " service.");
            }
            this.dead = false;
            return true;
        }

        public boolean isDead() {
            return this.dead;
        }
    }

    class Service {
        private final URI uri;
        private final String broadcastString;

        public Service(URI uri) {
            this.uri = uri;
            this.broadcastString = MulticastDiscoveryAgent.this.groupPrefix + uri.toString();
        }

        public Service(String uriString) throws URISyntaxException {
            URI uri = new URI(uriString);
            this.uri = uri = new URI(uri.getSchemeSpecificPart());
            this.broadcastString = uriString;
        }
    }
}

