/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

public class MulticastSearch {
    private static final int BUFF_SIZE = 8192;
    private final MulticastSocket multicast;

    public MulticastSearch() throws IOException {
        this("239.255.3.2", 6142);
    }

    public MulticastSearch(String host, int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(host);
        this.multicast = new MulticastSocket(port);
        this.multicast.joinGroup(inetAddress);
        this.multicast.setSoTimeout(500);
    }

    public URI search(int timeout, TimeUnit milliseconds) throws IOException {
        return this.search(new DefaultFilter(), timeout, milliseconds);
    }

    public URI search() throws IOException {
        return this.search(new DefaultFilter(), 0L, TimeUnit.MILLISECONDS);
    }

    public URI search(Filter filter) throws IOException {
        return this.search(filter, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI search(Filter filter, long timeout, TimeUnit unit) throws IOException {
        timeout = unit.convert(timeout, TimeUnit.MILLISECONDS);
        long waited = 0L;
        byte[] buf = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        while (true) {
            if (timeout != 0L) {
                if (waited >= timeout) return null;
            }
            long start = System.currentTimeMillis();
            try {
                this.multicast.receive(packet);
                if (packet.getLength() <= 0) continue;
                String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                try {
                    URI service = new URI(str);
                    if (service == null || !filter.accept(service)) continue;
                    URI uRI = service;
                    return uRI;
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                continue;
            }
            catch (SocketTimeoutException e) {
                continue;
            }
            catch (SocketException e) {
                System.out.println(e.getClass().getName() + ": " + e.getMessage());
                continue;
            }
            finally {
                long stop = System.currentTimeMillis();
                waited += stop - start;
                continue;
            }
            break;
        }
    }

    public static class DefaultFilter
    implements Filter {
        public boolean accept(URI service) {
            return true;
        }
    }

    public static interface Filter {
        public boolean accept(URI var1);
    }
}

