/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;

public class HttpConnectionFactory
implements ConnectionFactory {
    public Connection getConnection(URI uri) throws IOException {
        return new HttpConnection(uri);
    }

    public static class HttpConnection
    implements Connection {
        private HttpURLConnection httpURLConnection;
        private InputStream inputStream;
        private OutputStream outputStream;
        private URI uri;

        public HttpConnection(URI uri) throws IOException {
            this.uri = uri;
            URL url = uri.toURL();
            this.httpURLConnection = (HttpURLConnection)url.openConnection();
            this.httpURLConnection.setDoOutput(true);
            this.httpURLConnection.connect();
        }

        public void discard() {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public URI getURI() {
            return this.uri;
        }

        public void close() throws IOException {
            IOException exception;
            block7: {
                exception = null;
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                }
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        if (exception != null) break block7;
                        exception = e;
                    }
                }
            }
            this.inputStream = null;
            this.outputStream = null;
            this.httpURLConnection = null;
            if (exception != null) {
                throw exception;
            }
        }

        public OutputStream getOuputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = this.httpURLConnection.getOutputStream();
            }
            return this.outputStream;
        }

        public InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.httpURLConnection.getInputStream();
            }
            return this.inputStream;
        }
    }
}

