/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.openejb.client.ClientIdentityPrincipal;
import org.apache.openejb.client.ClientSecurity;
import org.apache.openejb.client.ServerMetaData;

public class ClientLoginModule
implements LoginModule {
    private static final Logger log = Logger.getLogger("OpenEJB.client");
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String serverUri;
    private boolean debug;
    private String user;
    private Object clientIdentity;
    private ClientIdentityPrincipal principal;
    private String realmNameSeparator;
    private String realmName;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.serverUri = System.getProperty("openejb.server.uri");
        if (this.serverUri == null) {
            this.serverUri = (String)options.get("openejb.server.uri");
        }
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (this.debug) {
            log.config("Initialized ClientLoginModule: debug=" + this.debug);
        }
        if (options.containsKey("RealmNameSeparator")) {
            this.realmNameSeparator = (String)options.get("RealmNameSeparator");
        }
        if (options.containsKey("RealmName")) {
            this.realmName = (String)options.get("RealmName");
        }
    }

    public boolean login() throws LoginException {
        String[] strings;
        URI location;
        block10: {
            location = null;
            try {
                location = new URI(this.serverUri);
            }
            catch (Exception e) {
                if (this.serverUri.indexOf("://") != -1) break block10;
                try {
                    location = new URI("foo://" + this.serverUri);
                }
                catch (URISyntaxException giveUp) {
                    throw new LoginException("Invalid openejb.server.uri " + this.serverUri);
                }
            }
        }
        ServerMetaData server = new ServerMetaData(location);
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (this.realmNameSeparator != null && (strings = this.user.split(this.realmNameSeparator)).length == 2) {
            this.realmName = strings[0];
            this.user = strings[1];
        }
        this.clientIdentity = this.realmName != null ? ClientSecurity.directAuthentication(this.realmName, this.user, new String(tmpPassword), server) : ClientSecurity.directAuthentication(this.user, new String(tmpPassword), server);
        if (this.debug) {
            log.config("login " + this.user);
        }
        return true;
    }

    public boolean commit() throws LoginException {
        this.principal = new ClientIdentityPrincipal(this.user, this.clientIdentity);
        this.subject.getPrincipals().add(this.principal);
        if (this.debug) {
            log.config("commit");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            log.config("abort");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        if (this.debug) {
            log.config("logout");
        }
        return true;
    }

    private void clear() {
        this.user = null;
        this.clientIdentity = null;
        this.principal = null;
    }
}

