/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.meta.SourceTracker;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.util.ClassResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo,
SourceTracker {
    public static final String KEY_PROVIDER = "javax.persistence.provider";
    private static final Localizer s_loc = Localizer.forPackage(PersistenceUnitInfoImpl.class);
    private String _name;
    private final Properties _props = new Properties();
    private PersistenceUnitTransactionType _transType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    private String _providerClassName;
    private List<String> _mappingFileNames;
    private List<String> _entityClassNames;
    private List<URL> _jarFiles;
    private String _jtaDataSourceName;
    private DataSource _jtaDataSource;
    private String _nonJtaDataSourceName;
    private DataSource _nonJtaDataSource;
    private boolean _excludeUnlisted;
    private URL _persistenceXmlFile;
    private URL _root;

    public ClassLoader getClassLoader() {
        return null;
    }

    public ClassLoader getNewTempClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newTemporaryClassLoaderAction(AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction())));
    }

    public String getPersistenceUnitName() {
        return this._name;
    }

    public void setPersistenceUnitName(String emName) {
        this._name = emName;
    }

    public String getPersistenceProviderClassName() {
        return this._providerClassName;
    }

    public void setPersistenceProviderClassName(String providerClassName) {
        this._providerClassName = providerClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this._transType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transType) {
        this._transType = transType;
    }

    public String getJtaDataSourceName() {
        return this._jtaDataSourceName;
    }

    public void setJtaDataSourceName(String jta) {
        this._jtaDataSourceName = jta;
        if (jta != null) {
            this._jtaDataSource = null;
        }
    }

    public DataSource getJtaDataSource() {
        return this._jtaDataSource;
    }

    public void setJtaDataSource(DataSource ds) {
        this._jtaDataSource = ds;
        if (ds != null) {
            this._jtaDataSourceName = null;
        }
    }

    public String getNonJtaDataSourceName() {
        return this._nonJtaDataSourceName;
    }

    public void setNonJtaDataSourceName(String nonJta) {
        this._nonJtaDataSourceName = nonJta;
        if (nonJta != null) {
            this._nonJtaDataSource = null;
        }
    }

    public DataSource getNonJtaDataSource() {
        return this._nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource ds) {
        this._nonJtaDataSource = ds;
        if (ds != null) {
            this._nonJtaDataSourceName = null;
        }
    }

    public URL getPersistenceUnitRootUrl() {
        return this._root;
    }

    public void setPersistenceUnitRootUrl(URL root) {
        this._root = root;
    }

    public boolean excludeUnlistedClasses() {
        return this._excludeUnlisted;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlisted) {
        this._excludeUnlisted = excludeUnlisted;
    }

    public List<String> getMappingFileNames() {
        return this._mappingFileNames == null ? Collections.EMPTY_LIST : this._mappingFileNames;
    }

    public void addMappingFileName(String name) {
        if (this._mappingFileNames == null) {
            this._mappingFileNames = new ArrayList<String>();
        }
        this._mappingFileNames.add(name);
    }

    public List<URL> getJarFileUrls() {
        return this._jarFiles == null ? Collections.EMPTY_LIST : this._jarFiles;
    }

    public void addJarFile(URL jar) {
        if (this._jarFiles == null) {
            this._jarFiles = new ArrayList<URL>();
        }
        this._jarFiles.add(jar);
    }

    public void addJarFileName(String name) {
        MultiClassLoader loader = (MultiClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        loader.addClassLoader(this.getClass().getClassLoader());
        loader.addClassLoader(MultiClassLoader.THREAD_LOADER);
        URL url = (URL)AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(loader, name));
        if (url != null) {
            this.addJarFile(url);
            return;
        }
        String[] cp = ((String)AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction("java.class.path"))).split(J2DoPrivHelper.getPathSeparator());
        for (int i = 0; i < cp.length; ++i) {
            if (!cp[i].equals(name) && !cp[i].endsWith(File.separatorChar + name)) continue;
            try {
                this.addJarFile((URL)AccessController.doPrivileged(J2DoPrivHelper.toURLAction(new File(cp[i]))));
                return;
            }
            catch (PrivilegedActionException pae) {
                break;
            }
            catch (MalformedURLException mue) {
                break;
            }
        }
        throw new IllegalArgumentException(s_loc.get("bad-jar-name", name).getMessage());
    }

    public List<String> getManagedClassNames() {
        return this._entityClassNames == null ? Collections.EMPTY_LIST : this._entityClassNames;
    }

    public void addManagedClassName(String name) {
        if (this._entityClassNames == null) {
            this._entityClassNames = new ArrayList<String>();
        }
        this._entityClassNames.add(name);
    }

    public Properties getProperties() {
        return this._props;
    }

    public void setProperty(String key, String value) {
        this._props.setProperty(key, value);
    }

    public void addTransformer(ClassTransformer transformer) {
        throw new UnsupportedOperationException();
    }

    public URL getPersistenceXmlFileUrl() {
        return this._persistenceXmlFile;
    }

    public void setPersistenceXmlFileUrl(URL url) {
        this._persistenceXmlFile = url;
    }

    public void fromUserProperties(Map map) {
        if (map == null) {
            return;
        }
        for (Map.Entry o : map.entrySet()) {
            Object key = o.getKey();
            Object val = o.getValue();
            if (KEY_PROVIDER.equals(key)) {
                this.setPersistenceProviderClassName((String)val);
                continue;
            }
            if ("javax.persistence.transactionType".equals(key)) {
                PersistenceUnitTransactionType ttype = val instanceof String ? Enum.valueOf(PersistenceUnitTransactionType.class, (String)val) : (PersistenceUnitTransactionType)val;
                this.setTransactionType(ttype);
                continue;
            }
            if ("javax.persistence.jtaDataSource".equals(key)) {
                if (val instanceof String) {
                    this.setJtaDataSourceName((String)val);
                    continue;
                }
                this.setJtaDataSource((DataSource)val);
                continue;
            }
            if ("javax.persistence.nonJtaDataSource".equals(key)) {
                if (val instanceof String) {
                    this.setNonJtaDataSourceName((String)val);
                    continue;
                }
                this.setNonJtaDataSource((DataSource)val);
                continue;
            }
            this._props.put(key, val);
        }
    }

    public Map toOpenJPAProperties() {
        return PersistenceUnitInfoImpl.toOpenJPAProperties(this);
    }

    public static Map toOpenJPAProperties(PersistenceUnitInfo info) {
        Properties props;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        HashSet added = new HashSet();
        if (info.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            PersistenceUnitInfoImpl.put(map, added, "TransactionMode", "managed");
        }
        boolean hasJta = false;
        DataSource ds = info.getJtaDataSource();
        if (ds != null) {
            PersistenceUnitInfoImpl.put(map, added, "ConnectionFactory", ds);
            PersistenceUnitInfoImpl.put(map, added, "ConnectionFactoryMode", "managed");
            hasJta = true;
        } else if (info instanceof PersistenceUnitInfoImpl && ((PersistenceUnitInfoImpl)info).getJtaDataSourceName() != null) {
            PersistenceUnitInfoImpl.put(map, added, "ConnectionFactoryName", ((PersistenceUnitInfoImpl)info).getJtaDataSourceName());
            PersistenceUnitInfoImpl.put(map, added, "ConnectionFactoryMode", "managed");
            hasJta = true;
        }
        ds = info.getNonJtaDataSource();
        if (ds != null) {
            if (!hasJta) {
                PersistenceUnitInfoImpl.put(map, added, "ConnectionFactory", ds);
            } else {
                PersistenceUnitInfoImpl.put(map, added, "ConnectionFactory2", ds);
            }
        } else if (info instanceof PersistenceUnitInfoImpl && ((PersistenceUnitInfoImpl)info).getNonJtaDataSourceName() != null) {
            String nonJtaName = ((PersistenceUnitInfoImpl)info).getNonJtaDataSourceName();
            if (!hasJta) {
                PersistenceUnitInfoImpl.put(map, added, "ConnectionFactoryName", nonJtaName);
            } else {
                PersistenceUnitInfoImpl.put(map, added, "ConnectionFactory2Name", nonJtaName);
            }
        }
        if (info.getClassLoader() != null) {
            PersistenceUnitInfoImpl.put(map, added, "ClassResolver", new ClassResolverImpl(info.getClassLoader()));
        }
        if ((props = info.getProperties()) != null) {
            for (String key : added) {
                if (!Configurations.containsProperty(key, props)) continue;
                Configurations.removeProperty(key, props);
            }
            map.putAll(props);
            map.remove("ClassTransformerOptions");
        }
        if (!Configurations.containsProperty("Id", map)) {
            map.put("openjpa.Id", info.getPersistenceUnitName());
        }
        Properties metaFactoryProps = new Properties();
        if (info.getManagedClassNames() != null && !info.getManagedClassNames().isEmpty()) {
            StringBuffer types = new StringBuffer();
            for (String type : info.getManagedClassNames()) {
                if (types.length() > 0) {
                    types.append(';');
                }
                types.append(type);
            }
            metaFactoryProps.put("Types", types.toString());
        }
        if (info.getJarFileUrls() != null && !info.getJarFileUrls().isEmpty() || !info.excludeUnlistedClasses() && info.getPersistenceUnitRootUrl() != null) {
            StringBuffer jars = new StringBuffer();
            String file = null;
            if (!info.excludeUnlistedClasses() && info.getPersistenceUnitRootUrl() != null) {
                URL url = info.getPersistenceUnitRootUrl();
                if ("file".equals(url.getProtocol())) {
                    file = URLDecoder.decode(url.getPath());
                } else {
                    jars.append(url);
                }
            }
            for (URL jar : info.getJarFileUrls()) {
                if (jars.length() > 0) {
                    jars.append(';');
                }
                jars.append(jar);
            }
            if (file != null) {
                metaFactoryProps.put("Files", file);
            }
            if (jars.length() != 0) {
                metaFactoryProps.put("URLs", jars.toString());
            }
        }
        if (info.getMappingFileNames() != null && !info.getMappingFileNames().isEmpty()) {
            StringBuffer rsrcs = new StringBuffer();
            for (String rsrc : info.getMappingFileNames()) {
                if (rsrcs.length() > 0) {
                    rsrcs.append(';');
                }
                rsrcs.append(rsrc);
            }
            metaFactoryProps.put("Resources", rsrcs.toString());
        }
        if (!metaFactoryProps.isEmpty()) {
            String key;
            key = ProductDerivations.getConfigurationKey("MetaDataFactory", map);
            map.put(key, Configurations.combinePlugins((String)map.get(key), Configurations.serializeProperties(metaFactoryProps)));
        }
        if (info.getPersistenceProviderClassName() != null) {
            map.put(KEY_PROVIDER, info.getPersistenceProviderClassName());
        }
        return map;
    }

    private static void put(Map map, Set added, String key, Object val) {
        map.put("openjpa." + key, val);
        added.add(key);
    }

    @Override
    public File getSourceFile() {
        if (this._persistenceXmlFile == null) {
            return null;
        }
        try {
            return new File(this._persistenceXmlFile.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getSourceScope() {
        return null;
    }

    @Override
    public int getSourceType() {
        return 2;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public int getColNumber() {
        return 0;
    }

    @Override
    public String getResourceName() {
        return "PersistenceUnitInfo:" + this._name;
    }

    public static class ClassResolverImpl
    implements ClassResolver {
        private final ClassLoader _loader;

        public ClassResolverImpl(ClassLoader loader) {
            this._loader = loader;
        }

        public ClassLoader getClassLoader(Class ctx, ClassLoader env) {
            return this._loader;
        }
    }
}

