/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.QueryHint;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.SourceTracker;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.xml.Commentable;
import org.apache.openjpa.meta.AbstractCFMetaDataFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.meta.MetaDataInheritanceComparator;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.AnnotationBuilder;
import org.apache.openjpa.persistence.MetaDataTag;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.util.InternalException;
import serp.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPersistenceMetaDataSerializer
implements AbstractCFMetaDataFactory.Serializer {
    protected static final int TYPE_SEQ = 10;
    protected static final int TYPE_QUERY = 20;
    protected static final int TYPE_META = 30;
    protected static final int TYPE_CLASS_SEQS = 40;
    protected static final int TYPE_CLASS_QUERIES = 50;
    private static final Localizer _loc = Localizer.forPackage(AnnotationPersistenceMetaDataSerializer.class);
    private Log _log = null;
    private final OpenJPAConfiguration _conf;
    private Map<String, ClassMetaData> _metas = null;
    private Map<String, List> _queries = null;
    private Map<String, List> _seqs = null;
    private int _mode = 0;
    private SerializationComparator _comp = null;
    private Map<ClassMetaData, List<AnnotationBuilder>> _clsAnnos = null;
    private Map<FieldMetaData, List<AnnotationBuilder>> _fldAnnos = null;
    private Map<SequenceMetaData, List<AnnotationBuilder>> _seqAnnos = null;
    private Map<QueryMetaData, List<AnnotationBuilder>> _qryAnnos = null;

    public AnnotationPersistenceMetaDataSerializer(OpenJPAConfiguration conf) {
        this._conf = conf;
        this.setLog(conf.getLog("openjpa.MetaData"));
        this.setMode(7);
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public Log getLog() {
        return this._log;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public int getMode() {
        return this._mode;
    }

    @Override
    public void setMode(int mode) {
        this._mode = mode;
    }

    public void setMode(int mode, boolean on) {
        if (mode == 0) {
            this.setMode(0);
        } else if (on) {
            this.setMode(this._mode | mode);
        } else {
            this.setMode(this._mode & ~mode);
        }
    }

    protected boolean isMetaDataMode() {
        return (this._mode & 1) != 0;
    }

    protected boolean isQueryMode() {
        return (this._mode & 4) != 0;
    }

    protected boolean isMappingMode() {
        return (this._mode & 2) != 0;
    }

    protected boolean isMappingMode(ClassMetaData meta) {
        return !(!this.isMappingMode() || (meta.getSourceMode() & 2) == 0 || meta.getEmbeddingMetaData() == null && meta.isEmbeddedOnly() || meta.getEmbeddingMetaData() != null && !this.isMappingMode(meta.getEmbeddingMetaData()));
    }

    protected boolean isMappingMode(ValueMetaData vmd) {
        return this.isMappingMode(vmd.getFieldMetaData().getDefiningMetaData());
    }

    @Override
    public void addMetaData(ClassMetaData meta) {
        if (meta == null) {
            return;
        }
        if (this._metas == null) {
            this._metas = new HashMap<String, ClassMetaData>();
        }
        this._metas.put(meta.getDescribedType().getName(), meta);
    }

    @Override
    public void addSequenceMetaData(SequenceMetaData meta) {
        if (meta == null) {
            return;
        }
        ArrayList<SequenceMetaData> seqs = null;
        String defName = null;
        if (meta.getSourceScope() instanceof Class) {
            defName = ((Class)meta.getSourceScope()).getName();
        }
        if (this._seqs == null) {
            this._seqs = new HashMap<String, List>();
        } else {
            seqs = this._seqs.get(defName);
        }
        if (seqs == null) {
            seqs = new ArrayList<SequenceMetaData>(3);
            seqs.add(meta);
            this._seqs.put(defName, seqs);
        } else if (!seqs.contains(meta)) {
            seqs.add(meta);
        }
    }

    @Override
    public void addQueryMetaData(QueryMetaData meta) {
        if (meta == null) {
            return;
        }
        ArrayList<QueryMetaData> queries = null;
        String defName = null;
        if (meta.getSourceScope() instanceof Class) {
            defName = ((Class)meta.getSourceScope()).getName();
        }
        if (this._queries == null) {
            this._queries = new HashMap<String, List>();
        } else {
            queries = this._queries.get(defName);
        }
        if (queries == null) {
            queries = new ArrayList<QueryMetaData>(3);
            queries.add(meta);
            this._queries.put(defName, queries);
        } else if (!queries.contains(meta)) {
            queries.add(meta);
        }
    }

    @Override
    public void addAll(MetaDataRepository repos) {
        if (repos == null) {
            return;
        }
        for (ClassMetaData classMetaData : repos.getMetaDatas()) {
            this.addMetaData(classMetaData);
        }
        for (MetaDataContext metaDataContext : repos.getSequenceMetaDatas()) {
            this.addSequenceMetaData((SequenceMetaData)metaDataContext);
        }
        for (QueryMetaData queryMetaData : repos.getQueryMetaDatas()) {
            this.addQueryMetaData(queryMetaData);
        }
    }

    @Override
    public boolean removeMetaData(ClassMetaData meta) {
        return this._metas != null && meta != null && this._metas.remove(meta.getDescribedType().getName()) != null;
    }

    public boolean removeSequenceMetaData(SequenceMetaData meta) {
        List seqs;
        if (this._seqs == null || meta == null) {
            return false;
        }
        String defName = null;
        if (meta.getSourceScope() instanceof Class) {
            defName = ((Class)meta.getSourceScope()).getName();
        }
        if ((seqs = this._seqs.get(defName)) == null) {
            return false;
        }
        if (!seqs.remove(meta)) {
            return false;
        }
        if (seqs.isEmpty()) {
            this._seqs.remove(defName);
        }
        return true;
    }

    public boolean removeQueryMetaData(QueryMetaData meta) {
        List queries;
        if (this._queries == null || meta == null) {
            return false;
        }
        String defName = null;
        if (meta.getSourceScope() instanceof Class) {
            defName = ((Class)meta.getSourceScope()).getName();
        }
        if ((queries = this._queries.get(defName)) == null) {
            return false;
        }
        if (!queries.remove(meta)) {
            return false;
        }
        if (queries.isEmpty()) {
            this._queries.remove(defName);
        }
        return true;
    }

    public boolean removeAll(MetaDataRepository repos) {
        if (repos == null) {
            return false;
        }
        boolean removed = false;
        ClassMetaData[] metas = repos.getMetaDatas();
        for (int i = 0; i < metas.length; ++i) {
            removed |= this.removeMetaData(metas[i]);
        }
        SequenceMetaData[] seqs = repos.getSequenceMetaDatas();
        for (int i = 0; i < seqs.length; ++i) {
            removed |= this.removeSequenceMetaData(seqs[i]);
        }
        QueryMetaData[] queries = repos.getQueryMetaDatas();
        for (int i = 0; i < queries.length; ++i) {
            removed |= this.removeQueryMetaData(queries[i]);
        }
        return removed;
    }

    public void clear() {
        if (this._metas != null) {
            this._metas.clear();
        }
        if (this._seqs != null) {
            this._seqs.clear();
        }
        if (this._queries != null) {
            this._queries.clear();
        }
    }

    protected void addSystemMappingElements(Collection toSerialize) {
    }

    private void serializationSort(List objs) {
        if (objs == null || objs.isEmpty()) {
            return;
        }
        if (this._comp == null) {
            this._comp = this.newSerializationComparator();
        }
        Collections.sort(objs, this._comp);
    }

    protected SerializationComparator newSerializationComparator() {
        return this._comp;
    }

    private void addSequenceMetaDatas(Collection all) {
        if (this._seqs == null) {
            return;
        }
        for (Map.Entry<String, List> entry : this._seqs.entrySet()) {
            if (entry.getKey() == null) {
                all.addAll(entry.getValue());
                continue;
            }
            if (this._metas != null && this._metas.containsKey(entry.getKey())) continue;
            all.add(new ClassSeqs(entry.getValue()));
        }
    }

    private void addQueryMetaDatas(Collection all) {
        if (this._queries == null) {
            return;
        }
        for (Map.Entry<String, List> entry : this._queries.entrySet()) {
            if (entry.getKey() == null) {
                all.addAll(entry.getValue());
                continue;
            }
            if (this._mode != 4 && this._metas != null && this._metas.containsKey(entry.getKey())) continue;
            all.add(new ClassQueries(entry.getValue()));
        }
    }

    protected AnnotationBuilder newAnnotationBuilder(Class<? extends Annotation> annType) {
        return new AnnotationBuilder(annType);
    }

    protected void addAnnotation(AnnotationBuilder ab, Object meta) {
        if (meta instanceof ClassMetaData) {
            this.addAnnotation(ab, (ClassMetaData)meta);
        } else if (meta instanceof FieldMetaData) {
            this.addAnnotation(ab, (FieldMetaData)meta);
        } else if (meta instanceof SequenceMetaData) {
            this.addAnnotation(ab, (SequenceMetaData)meta);
        } else if (meta instanceof QueryMetaData) {
            this.addAnnotation(ab, (QueryMetaData)meta);
        }
    }

    protected void addAnnotation(AnnotationBuilder ab, ClassMetaData meta) {
        List<AnnotationBuilder> list;
        if (this._clsAnnos == null) {
            this._clsAnnos = new HashMap<ClassMetaData, List<AnnotationBuilder>>();
        }
        if ((list = this._clsAnnos.get(meta)) == null) {
            list = new ArrayList<AnnotationBuilder>();
            this._clsAnnos.put(meta, list);
        }
        list.add(ab);
    }

    protected void addAnnotation(AnnotationBuilder ab, FieldMetaData meta) {
        List<AnnotationBuilder> list;
        if (this._fldAnnos == null) {
            this._fldAnnos = new HashMap<FieldMetaData, List<AnnotationBuilder>>();
        }
        if ((list = this._fldAnnos.get(meta)) == null) {
            list = new ArrayList<AnnotationBuilder>();
            this._fldAnnos.put(meta, list);
        }
        list.add(ab);
    }

    protected void addAnnotation(AnnotationBuilder ab, SequenceMetaData meta) {
        List<AnnotationBuilder> list;
        if (this._seqAnnos == null) {
            this._seqAnnos = new HashMap<SequenceMetaData, List<AnnotationBuilder>>();
        }
        if ((list = this._seqAnnos.get(meta)) == null) {
            list = new ArrayList<AnnotationBuilder>();
            this._seqAnnos.put(meta, list);
        }
        list.add(ab);
    }

    protected void addAnnotation(AnnotationBuilder ab, QueryMetaData meta) {
        List<AnnotationBuilder> list;
        if (this._qryAnnos == null) {
            this._qryAnnos = new HashMap<QueryMetaData, List<AnnotationBuilder>>();
        }
        if ((list = this._qryAnnos.get(meta)) == null) {
            list = new ArrayList<AnnotationBuilder>();
            this._qryAnnos.put(meta, list);
        }
        list.add(ab);
    }

    protected AnnotationBuilder addAnnotation(Class<? extends Annotation> annType, ClassMetaData meta) {
        AnnotationBuilder ab = this.newAnnotationBuilder(annType);
        if (meta == null) {
            return ab;
        }
        this.addAnnotation(ab, meta);
        return ab;
    }

    protected AnnotationBuilder addAnnotation(Class<? extends Annotation> annType, FieldMetaData meta) {
        AnnotationBuilder ab = this.newAnnotationBuilder(annType);
        if (meta == null) {
            return ab;
        }
        this.addAnnotation(ab, meta);
        return ab;
    }

    protected AnnotationBuilder addAnnotation(Class<? extends Annotation> annType, SequenceMetaData meta) {
        AnnotationBuilder ab = this.newAnnotationBuilder(annType);
        if (meta == null) {
            return ab;
        }
        this.addAnnotation(ab, meta);
        return ab;
    }

    protected AnnotationBuilder addAnnotation(Class<? extends Annotation> annType, QueryMetaData meta) {
        AnnotationBuilder ab = this.newAnnotationBuilder(annType);
        if (meta == null) {
            return ab;
        }
        this.addAnnotation(ab, meta);
        return ab;
    }

    protected void serialize(Collection objects) {
        block7: for (Object obj : objects) {
            int type = this.type(obj);
            switch (type) {
                case 30: {
                    this.serializeClass((ClassMetaData)obj);
                    break;
                }
                case 10: {
                    if (this.isMappingMode()) {
                        this.serializeSequence((SequenceMetaData)obj);
                    }
                }
                case 20: {
                    this.serializeQuery((QueryMetaData)obj);
                    break;
                }
                case 50: {
                    for (Commentable commentable : ((ClassQueries)obj).getQueries()) {
                        this.serializeQuery((QueryMetaData)commentable);
                    }
                    continue block7;
                }
                case 40: {
                    if (!this.isMappingMode()) continue block7;
                    for (Commentable commentable : ((ClassSeqs)obj).getSequences()) {
                        this.serializeSequence((SequenceMetaData)commentable);
                    }
                    continue block7;
                }
                default: {
                    if (!this.isMappingMode()) continue block7;
                    this.serializeSystemMappingElement(obj);
                }
            }
        }
    }

    protected int type(Object o) {
        if (o instanceof ClassMetaData) {
            return 30;
        }
        if (o instanceof QueryMetaData) {
            return 20;
        }
        if (o instanceof SequenceMetaData) {
            return 10;
        }
        if (o instanceof ClassQueries) {
            return 50;
        }
        if (o instanceof ClassSeqs) {
            return 40;
        }
        return -1;
    }

    protected void serializeSystemMappingElement(Object obj) {
    }

    private void serializeQuery(QueryMetaData meta) {
        Log log = this.getLog();
        if (log.isInfoEnabled()) {
            if (meta.getSourceScope() instanceof Class) {
                log.info(_loc.get("ser-cls-query", meta.getSourceScope(), meta.getName()));
            } else {
                log.info(_loc.get("ser-query", meta.getName()));
            }
        }
        Class ann = "openjpa.SQL".equals(meta.getLanguage()) ? NamedNativeQuery.class : NamedQuery.class;
        AnnotationBuilder abQry = this.addAnnotation(ann, meta);
        abQry.add("name", meta.getName());
        abQry.add("query", meta.getQueryString());
        if ("openjpa.SQL".equals(meta.getLanguage()) && meta.getResultType() != null) {
            abQry.add("resultClass", meta.getResultType());
        }
        this.serializeQueryHints(meta, abQry);
    }

    private void serializeQueryHints(QueryMetaData meta, AnnotationBuilder ab) {
        String[] hints = meta.getHintKeys();
        Object[] values = meta.getHintValues();
        for (int i = 0; i < hints.length; ++i) {
            AnnotationBuilder abHint = this.newAnnotationBuilder(QueryHint.class);
            abHint.add("name", hints[i]);
            abHint.add("value", String.valueOf(values[i]));
            ab.add("hints", abHint);
        }
    }

    protected void serializeSequence(SequenceMetaData meta) {
        Options map;
        Log log = this.getLog();
        if (log.isInfoEnabled()) {
            log.info(_loc.get("ser-sequence", meta.getName()));
        }
        AnnotationBuilder ab = this.addAnnotation(SequenceGenerator.class, meta);
        ab.add("name", meta.getName());
        String plugin = meta.getSequencePlugin();
        String clsName = Configurations.getClassName(plugin);
        String props = Configurations.getProperties(plugin);
        String ds = null;
        if (props != null && (ds = (String)(map = Configurations.parseProperties(props)).remove("Sequence")) != null) {
            props = Configurations.serializeProperties(map);
            plugin = Configurations.getPlugin(clsName, props);
        }
        if (ds != null) {
            ab.add("sequenceName", ds);
        } else if (plugin != null && !"native".equals(plugin)) {
            ab.add("sequenceName", plugin);
        }
        if (meta.getInitialValue() != 0 && meta.getInitialValue() != -1) {
            ab.add("initialValue", meta.getInitialValue());
        }
        if (meta.getAllocate() != 50 && meta.getAllocate() != -1) {
            ab.add("allocationSize", meta.getAllocate());
        }
    }

    protected void serializeClass(ClassMetaData meta) {
        int i;
        Log log = this.getLog();
        if (log.isInfoEnabled()) {
            log.info(_loc.get("ser-class", meta));
        }
        AnnotationBuilder abEntity = this.addAnnotation(AnnotationPersistenceMetaDataSerializer.getEntityAnnotationType(meta), meta);
        if (this.isMetaDataMode() && !meta.getTypeAlias().equals(Strings.getClassName((Class)meta.getDescribedType()))) {
            abEntity.add("name", meta.getTypeAlias());
        }
        if (this.isMappingMode()) {
            this.addClassMappingAnnotations(meta);
        }
        if (this.isMappingMode()) {
            this.serializeClassMappingContent(meta);
        }
        if (this.isMetaDataMode()) {
            this.serializeIdClass(meta);
        }
        if (this.isMappingMode()) {
            this.serializeInheritanceContent(meta);
        }
        if (this.isMappingMode()) {
            List seqs;
            List list = seqs = this._seqs == null ? null : this._seqs.get(meta.getDescribedType().getName());
            if (seqs != null) {
                this.serializationSort(seqs);
                for (i = 0; i < seqs.size(); ++i) {
                    this.serializeSequence((SequenceMetaData)seqs.get(i));
                }
            }
        }
        if (this.isQueryMode()) {
            List queries;
            List list = queries = this._queries == null ? null : this._queries.get(meta.getDescribedType().getName());
            if (queries != null) {
                this.serializationSort(queries);
                for (i = 0; i < queries.size(); ++i) {
                    this.serializeQuery((QueryMetaData)queries.get(i));
                }
            }
            if (this.isMappingMode()) {
                this.serializeQueryMappings(meta);
            }
        }
        ArrayList<FieldMetaData> fields = new ArrayList<FieldMetaData>(Arrays.asList(meta.getDefinedFieldsInListingOrder()));
        Collections.sort(fields, new FieldComparator());
        if (this.isMappingMode()) {
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                FieldMetaData fmd = (FieldMetaData)it.next();
                if (meta.getDefinedSuperclassField(fmd.getName()) == null) continue;
                FieldMetaData orig = meta.getPCSuperclassMetaData().getField(fmd.getName());
                if (this.serializeAttributeOverride(fmd, orig)) {
                    this.serializeAttributeOverrideContent(fmd, orig);
                }
                it.remove();
            }
        }
        if (fields.size() > 0 && (this.isMetaDataMode() || this.isMappingMode())) {
            for (FieldMetaData fmd : fields) {
                FieldMetaData orig = fmd.getDeclaringType() != fmd.getDefiningMetaData().getDescribedType() ? fmd.getDeclaringMetaData().getDeclaredField(fmd.getName()) : null;
                this.serializeField(fmd, orig);
            }
        }
    }

    private static Class<? extends Annotation> getEntityAnnotationType(ClassMetaData meta) {
        switch (AnnotationPersistenceMetaDataSerializer.getEntityTag(meta)) {
            case ENTITY: {
                return Entity.class;
            }
            case EMBEDDABLE: {
                return Embeddable.class;
            }
            case MAPPED_SUPERCLASS: {
                return MappedSuperclass.class;
            }
        }
        throw new IllegalStateException();
    }

    private static Class<? extends Annotation> getFieldAnnotationType(FieldMetaData fmd, PersistenceStrategy strat) {
        Class<EmbeddedId> ann = null;
        if (fmd.isPrimaryKey() && strat == PersistenceStrategy.EMBEDDED) {
            ann = EmbeddedId.class;
        } else if (fmd.isPrimaryKey()) {
            ann = Id.class;
        } else if (fmd.isVersion()) {
            ann = Version.class;
        } else {
            switch (strat) {
                case TRANSIENT: {
                    ann = Transient.class;
                    break;
                }
                case BASIC: {
                    ann = Basic.class;
                    break;
                }
                case EMBEDDED: {
                    ann = Embedded.class;
                    break;
                }
                case MANY_ONE: {
                    ann = ManyToOne.class;
                    break;
                }
                case ONE_ONE: {
                    ann = OneToOne.class;
                    break;
                }
                case ONE_MANY: {
                    ann = OneToMany.class;
                    break;
                }
                case MANY_MANY: {
                    ann = ManyToMany.class;
                }
            }
        }
        return ann;
    }

    private static MetaDataTag getEntityTag(ClassMetaData meta) {
        if (meta.isEmbeddedOnly() && meta.getPrimaryKeyFields().length == 0) {
            return MetaDataTag.EMBEDDABLE;
        }
        if (meta.isMapped()) {
            return MetaDataTag.ENTITY;
        }
        return MetaDataTag.MAPPED_SUPERCLASS;
    }

    protected void addClassMappingAnnotations(ClassMetaData mapping) {
    }

    private void serializeIdClass(ClassMetaData meta) {
        if (meta.getIdentityType() != 2 || meta.isOpenJPAIdentity()) {
            return;
        }
        ClassMetaData sup = meta.getPCSuperclassMetaData();
        Class oid = meta.getObjectIdType();
        if (oid != null && (sup == null || oid != sup.getObjectIdType())) {
            AnnotationBuilder ab = this.addAnnotation(IdClass.class, meta);
            ab.add(null, oid);
        }
    }

    protected void serializeClassMappingContent(ClassMetaData mapping) {
    }

    protected void serializeInheritanceContent(ClassMetaData mapping) {
    }

    protected void serializeQueryMappings(ClassMetaData meta) {
    }

    private void serializeField(FieldMetaData fmd, FieldMetaData orig) {
        if (fmd.getManagement() != 3 && !fmd.isExplicit()) {
            return;
        }
        PersistenceStrategy strat = this.getStrategy(fmd);
        ValueMetaData cascades = null;
        AnnotationBuilder ab = this.addAnnotation(AnnotationPersistenceMetaDataSerializer.getFieldAnnotationType(fmd, strat), fmd);
        if (!(fmd.isPrimaryKey() && strat == PersistenceStrategy.EMBEDDED || fmd.isPrimaryKey() || fmd.isVersion())) {
            switch (strat) {
                case BASIC: {
                    if (!this.isMetaDataMode()) break;
                    this.addBasicAttributes(fmd, ab);
                    break;
                }
                case MANY_ONE: {
                    if (this.isMetaDataMode()) {
                        this.addManyToOneAttributes(fmd, ab);
                    }
                    cascades = fmd;
                    break;
                }
                case ONE_ONE: {
                    if (this.isMetaDataMode()) {
                        this.addOneToOneAttributes(fmd, ab);
                    }
                    cascades = fmd;
                    break;
                }
                case ONE_MANY: {
                    if (this.isMetaDataMode()) {
                        this.addOneToManyAttributes(fmd, ab);
                    }
                    cascades = fmd.getElement();
                    break;
                }
                case MANY_MANY: {
                    if (this.isMetaDataMode()) {
                        this.addManyToManyAttributes(fmd, ab);
                    }
                    cascades = fmd.getElement();
                }
            }
            if (this.isMappingMode()) {
                this.addStrategyMappingAttributes(fmd, ab);
            }
        }
        if (this.isMappingMode(fmd)) {
            this.addFieldMappingAttributes(fmd, orig, ab);
        }
        if (fmd.getOrderDeclaration() != null && !"#element asc".equals(fmd.getOrderDeclaration())) {
            this.addAnnotation(OrderBy.class, fmd).add(null, fmd.getOrderDeclaration());
        }
        if (this.isMappingMode() && fmd.getKey().getValueMappedBy() != null) {
            AnnotationBuilder abMapKey = this.addAnnotation(MapKey.class, fmd);
            FieldMetaData mapBy = fmd.getKey().getValueMappedByMetaData();
            if (!mapBy.isPrimaryKey() || mapBy.getDefiningMetaData().getPrimaryKeyFields().length != 1) {
                abMapKey.add("name", fmd.getKey().getValueMappedBy());
            }
        }
        if (this.isMappingMode(fmd)) {
            this.serializeFieldMappingContent(fmd, strat, ab);
        }
        if (cascades != null && this.isMetaDataMode()) {
            this.serializeCascades(cascades, ab);
        }
    }

    protected void addFieldMappingAttributes(FieldMetaData fmd, FieldMetaData orig, AnnotationBuilder ab) {
    }

    protected boolean serializeAttributeOverride(FieldMetaData fmd, FieldMetaData orig) {
        return false;
    }

    private void serializeAttributeOverrideContent(FieldMetaData fmd, FieldMetaData orig) {
        AnnotationBuilder ab = this.addAnnotation(AttributeOverride.class, fmd);
        ab.add("name", fmd.getName());
        this.serializeAttributeOverrideMappingContent(fmd, orig, ab);
    }

    protected void serializeAttributeOverrideMappingContent(FieldMetaData fmd, FieldMetaData orig, AnnotationBuilder ab) {
    }

    private void serializeCascades(ValueMetaData vmd, AnnotationBuilder ab) {
        EnumSet<CascadeType> cascades = EnumSet.noneOf(CascadeType.class);
        if (vmd.getCascadePersist() == 1) {
            cascades.add(CascadeType.PERSIST);
        }
        if (vmd.getCascadeAttach() == 1) {
            cascades.add(CascadeType.MERGE);
        }
        if (vmd.getCascadeDelete() == 1) {
            cascades.add(CascadeType.REMOVE);
        }
        if (vmd.getCascadeRefresh() == 1) {
            cascades.add(CascadeType.REFRESH);
        }
        if (cascades.size() == 4) {
            cascades.clear();
            cascades.add(CascadeType.ALL);
        }
        if (!cascades.isEmpty()) {
            ab.add("cascade", cascades);
        }
    }

    protected PersistenceStrategy getStrategy(FieldMetaData fmd) {
        if (fmd.getManagement() == 0) {
            return PersistenceStrategy.TRANSIENT;
        }
        if (fmd.isSerialized() || fmd.getDeclaredType() == byte[].class || fmd.getDeclaredType() == Byte[].class || fmd.getDeclaredType() == char[].class || fmd.getDeclaredType() == Character[].class) {
            return PersistenceStrategy.BASIC;
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 15: {
                if (fmd.isEmbedded()) {
                    return PersistenceStrategy.EMBEDDED;
                }
                if (fmd.getMappedBy() != null) {
                    return PersistenceStrategy.ONE_ONE;
                }
                FieldMetaData[] inverses = fmd.getInverseMetaDatas();
                if (inverses.length == 1 && inverses[0].getTypeCode() == 15 && inverses[0].getMappedByMetaData() == fmd) {
                    return PersistenceStrategy.ONE_ONE;
                }
                return PersistenceStrategy.MANY_ONE;
            }
            case 11: 
            case 12: 
            case 13: {
                FieldMetaData mappedBy = fmd.getMappedByMetaData();
                if (mappedBy == null || mappedBy.getTypeCode() != 15) {
                    return PersistenceStrategy.MANY_MANY;
                }
                return PersistenceStrategy.ONE_MANY;
            }
            case 29: {
                return PersistenceStrategy.EMBEDDED;
            }
        }
        return PersistenceStrategy.BASIC;
    }

    private void addBasicAttributes(FieldMetaData fmd, AnnotationBuilder ab) {
        if (!fmd.isInDefaultFetchGroup()) {
            ab.add("fetch", (Enum)FetchType.LAZY);
        }
        if (fmd.getNullValue() == 2) {
            ab.add("optional", false);
        }
    }

    private void addManyToOneAttributes(FieldMetaData fmd, AnnotationBuilder ab) {
        if (!fmd.isInDefaultFetchGroup()) {
            ab.add("fetch", (Enum)FetchType.LAZY);
        }
        if (fmd.getNullValue() == 2) {
            ab.add("optional", false);
        }
    }

    private void addOneToOneAttributes(FieldMetaData fmd, AnnotationBuilder ab) {
        if (!fmd.isInDefaultFetchGroup()) {
            ab.add("fetch", (Enum)FetchType.LAZY);
        }
        if (fmd.getNullValue() == 2) {
            ab.add("optional", false);
        }
    }

    private void addOneToManyAttributes(FieldMetaData fmd, AnnotationBuilder ab) {
        if (fmd.isInDefaultFetchGroup()) {
            ab.add("fetch", (Enum)FetchType.EAGER);
        }
        this.addTargetEntityAttribute(fmd, ab);
    }

    private void addManyToManyAttributes(FieldMetaData fmd, AnnotationBuilder ab) {
        if (fmd.isInDefaultFetchGroup()) {
            ab.add("fetch", (Enum)FetchType.EAGER);
        }
        this.addTargetEntityAttribute(fmd, ab);
    }

    private void addTargetEntityAttribute(FieldMetaData fmd, AnnotationBuilder ab) {
        Member member = fmd.getBackingMember();
        Class[] types = member instanceof Field ? JavaVersions.getParameterizedTypes((Field)member) : (member instanceof Method ? JavaVersions.getParameterizedTypes((Method)member) : new Class[]{});
        switch (fmd.getDeclaredTypeCode()) {
            case 12: {
                if (types.length == 1) break;
                ab.add("targetEntity", fmd.getElement().getDeclaredType());
                break;
            }
            case 13: {
                if (types.length == 2) break;
                ab.add("targetEntity", fmd.getElement().getDeclaredType());
            }
        }
    }

    protected void serializeFieldMappingContent(FieldMetaData fmd, PersistenceStrategy strategy, AnnotationBuilder ab) {
    }

    protected void addStrategyMappingAttributes(FieldMetaData fmd, AnnotationBuilder ab) {
        if (fmd.getMappedBy() != null) {
            ab.add("mappedBy", fmd.getMappedBy());
        }
    }

    protected Collection getObjects() {
        ArrayList<ClassMetaData> all = new ArrayList<ClassMetaData>();
        if (this.isQueryMode()) {
            this.addQueryMetaDatas(all);
        }
        if (this.isMappingMode()) {
            this.addSequenceMetaDatas(all);
        }
        if ((this.isMetaDataMode() || this.isMappingMode()) && this._metas != null) {
            all.addAll(this._metas.values());
        }
        if (this.isMappingMode()) {
            this.addSystemMappingElements(all);
        }
        this.serializationSort(all);
        return all;
    }

    protected void writeAnnotations(Object meta, List<AnnotationBuilder> builders, Map output) {
        ArrayList<String> annos = new ArrayList<String>();
        for (AnnotationBuilder ab : builders) {
            annos.add(ab.toString());
        }
        output.put(meta, annos);
    }

    @Override
    public void serialize(Map output, int flags) throws IOException {
        Collection all = this.getObjects();
        this.serialize(all);
        if (this._clsAnnos != null) {
            for (ClassMetaData classMetaData : this._clsAnnos.keySet()) {
                this.writeAnnotations(classMetaData, this._clsAnnos.get(classMetaData), output);
            }
        }
        if (this._fldAnnos != null) {
            for (FieldMetaData fieldMetaData : this._fldAnnos.keySet()) {
                this.writeAnnotations(fieldMetaData, this._fldAnnos.get(fieldMetaData), output);
            }
        }
        if (this._seqAnnos != null) {
            for (SequenceMetaData sequenceMetaData : this._seqAnnos.keySet()) {
                this.writeAnnotations(sequenceMetaData, this._seqAnnos.get(sequenceMetaData), output);
            }
        }
        if (this._qryAnnos != null) {
            for (QueryMetaData queryMetaData : this._qryAnnos.keySet()) {
                this.writeAnnotations(queryMetaData, this._qryAnnos.get(queryMetaData), output);
            }
        }
    }

    @Override
    public void serialize(File file, int flags) throws IOException {
        try {
            FileWriter out = new FileWriter((String)AccessController.doPrivileged(J2DoPrivHelper.getCanonicalPathAction(file)), (flags & 2) > 0);
            this.serialize(out, flags);
            out.close();
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    @Override
    public void serialize(Writer out, int flags) throws IOException {
        HashMap output = new HashMap();
        this.serialize(output, flags);
        for (Object meta : output.keySet()) {
            out.write("--" + meta.toString());
            out.write("\n");
            List annos = (List)output.get(meta);
            for (String ann : annos) {
                out.write("\t");
                out.write(ann);
                out.write("\n");
            }
        }
    }

    @Override
    public void serialize(int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    private class FieldComparator
    implements Comparator {
        private FieldComparator() {
        }

        public int compare(Object o1, Object o2) {
            FieldMetaData fmd1 = (FieldMetaData)o1;
            FieldMetaData fmd2 = (FieldMetaData)o2;
            if (fmd1.isPrimaryKey()) {
                if (fmd2.isPrimaryKey()) {
                    return fmd1.compareTo(fmd2);
                }
                return -1;
            }
            if (fmd2.isPrimaryKey()) {
                return 1;
            }
            if (fmd1.isVersion()) {
                if (fmd2.isVersion()) {
                    return this.compareListingOrder(fmd1, fmd2);
                }
                return AnnotationPersistenceMetaDataSerializer.this.getStrategy(fmd2) == PersistenceStrategy.BASIC ? 1 : -1;
            }
            if (fmd2.isVersion()) {
                return AnnotationPersistenceMetaDataSerializer.this.getStrategy(fmd1) == PersistenceStrategy.BASIC ? -1 : 1;
            }
            int stcmp = AnnotationPersistenceMetaDataSerializer.this.getStrategy(fmd1).compareTo(AnnotationPersistenceMetaDataSerializer.this.getStrategy(fmd2));
            if (stcmp != 0) {
                return stcmp;
            }
            return this.compareListingOrder(fmd1, fmd2);
        }

        private int compareListingOrder(FieldMetaData fmd1, FieldMetaData fmd2) {
            int lcmp = fmd1.getListingIndex() - fmd2.getListingIndex();
            if (lcmp != 0) {
                return lcmp;
            }
            return fmd1.compareTo(fmd2);
        }
    }

    protected class SerializationComparator
    extends MetaDataInheritanceComparator {
        protected SerializationComparator() {
        }

        public int compare(Object o1, Object o2) {
            int t2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int t1 = AnnotationPersistenceMetaDataSerializer.this.type(o1);
            if (t1 != (t2 = AnnotationPersistenceMetaDataSerializer.this.type(o2))) {
                return t1 - t2;
            }
            switch (t1) {
                case 30: {
                    return this.compare((ClassMetaData)o1, (ClassMetaData)o2);
                }
                case 20: {
                    return this.compare((QueryMetaData)o1, (QueryMetaData)o2);
                }
                case 10: {
                    return this.compare((SequenceMetaData)o1, (SequenceMetaData)o2);
                }
                case 50: {
                    return ((Comparable)o1).compareTo(o2);
                }
                case 40: {
                    return ((Comparable)o1).compareTo(o2);
                }
            }
            return this.compareUnknown(o1, o2);
        }

        protected int compareUnknown(Object o1, Object o2) {
            throw new InternalException();
        }

        private int compare(ClassMetaData o1, ClassMetaData o2) {
            int li1 = o1.getListingIndex();
            int li2 = o2.getListingIndex();
            if (li1 == -1 && li2 == -1) {
                MetaDataTag t2;
                MetaDataTag t1 = AnnotationPersistenceMetaDataSerializer.getEntityTag(o1);
                if (t1.compareTo(t2 = AnnotationPersistenceMetaDataSerializer.getEntityTag(o2)) != 0) {
                    return t1.compareTo(t2);
                }
                int inher = super.compare(o1, o2);
                if (inher != 0) {
                    return inher;
                }
                return o1.getDescribedType().getName().compareTo(o2.getDescribedType().getName());
            }
            if (li1 == -1) {
                return 1;
            }
            if (li2 == -1) {
                return -1;
            }
            return li1 - li2;
        }

        private int compare(QueryMetaData o1, QueryMetaData o2) {
            if (!StringUtils.equals((String)o1.getLanguage(), (String)o2.getLanguage())) {
                if ("openjpa.SQL".equals(o1.getLanguage())) {
                    return 1;
                }
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }

        private int compare(SequenceMetaData o1, SequenceMetaData o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassQueries
    implements SourceTracker,
    Comparable<ClassQueries>,
    Comparator<QueryMetaData> {
        private final QueryMetaData[] _queries;

        public ClassQueries(List<QueryMetaData> queries) {
            if (queries == null || queries.isEmpty()) {
                throw new InternalException();
            }
            this._queries = queries.toArray(new QueryMetaData[queries.size()]);
            Arrays.sort(this._queries, this);
        }

        public QueryMetaData[] getQueries() {
            return this._queries;
        }

        @Override
        public int compare(QueryMetaData o1, QueryMetaData o2) {
            if (!StringUtils.equals((String)o1.getLanguage(), (String)o2.getLanguage())) {
                if ("openjpa.SQL".equals(o1.getLanguage())) {
                    return 1;
                }
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }

        @Override
        public File getSourceFile() {
            return this._queries[0].getSourceFile();
        }

        @Override
        public Object getSourceScope() {
            return this._queries[0].getSourceScope();
        }

        @Override
        public int getSourceType() {
            return this._queries[0].getSourceType();
        }

        @Override
        public String getResourceName() {
            return this._queries[0].getResourceName();
        }

        @Override
        public int getLineNumber() {
            return this._queries[0].getLineNumber();
        }

        @Override
        public int getColNumber() {
            return this._queries[0].getColNumber();
        }

        @Override
        public int compareTo(ClassQueries other) {
            if (other == this) {
                return 0;
            }
            if (other == null) {
                return -1;
            }
            Class scope = (Class)this.getSourceScope();
            Class oscope = (Class)other.getSourceScope();
            return scope.getName().compareTo(oscope.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassSeqs
    implements SourceTracker,
    Comparable<ClassSeqs>,
    Comparator<SequenceMetaData> {
        private final SequenceMetaData[] _seqs;

        public ClassSeqs(List<SequenceMetaData> seqs) {
            if (seqs == null || seqs.isEmpty()) {
                throw new InternalException();
            }
            this._seqs = seqs.toArray(new SequenceMetaData[seqs.size()]);
            Arrays.sort(this._seqs, this);
        }

        public SequenceMetaData[] getSequences() {
            return this._seqs;
        }

        @Override
        public int compare(SequenceMetaData o1, SequenceMetaData o2) {
            return o1.getName().compareTo(o2.getName());
        }

        @Override
        public File getSourceFile() {
            return this._seqs[0].getSourceFile();
        }

        @Override
        public Object getSourceScope() {
            return this._seqs[0].getSourceScope();
        }

        @Override
        public int getSourceType() {
            return this._seqs[0].getSourceType();
        }

        @Override
        public String getResourceName() {
            return this._seqs[0].getResourceName();
        }

        @Override
        public int getLineNumber() {
            return this._seqs[0].getLineNumber();
        }

        @Override
        public int getColNumber() {
            return this._seqs[0].getColNumber();
        }

        @Override
        public int compareTo(ClassSeqs other) {
            if (other == this) {
                return 0;
            }
            if (other == null) {
                return -1;
            }
            Class scope = (Class)this.getSourceScope();
            Class oscope = (Class)other.getSourceScope();
            return scope.getName().compareTo(oscope.getName());
        }
    }
}

