/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCSeqValue;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.meta.SequenceMetaData;

public class SequenceMapping
extends SequenceMetaData {
    public static final String IMPL_VALUE_TABLE = "value-table";
    public static final String IMPL_TABLE = "table";
    public static final String IMPL_CLASS_TABLE = "class-table";
    private static final String PROP_TABLE = "Table";
    private static final String PROP_SEQUENCE_COL = "SequenceColumn";
    private static final String PROP_PK_COL = "PrimaryKeyColumn";
    private static final String PROP_PK_VALUE = "PrimaryKeyValue";
    private static final String PROP_UNIQUE = "UniqueColumns";
    private File _mapFile = null;
    private String _table = null;
    private String _sequenceColumn = null;
    private String _primaryKeyColumn = null;
    private String _primaryKeyValue = null;
    private String[] _uniqueColumns = null;

    public SequenceMapping(String name, MappingRepository repos) {
        super(name, repos);
    }

    public File getMappingFile() {
        return this._mapFile;
    }

    public void setMappingFile(File file) {
        this._mapFile = file;
    }

    public String getTable() {
        return this._table;
    }

    public void setTable(String table) {
        this._table = table;
    }

    public String getSequenceColumn() {
        return this._sequenceColumn;
    }

    public void setSequenceColumn(String sequenceColumn) {
        this._sequenceColumn = sequenceColumn;
    }

    public String getPrimaryKeyColumn() {
        return this._primaryKeyColumn;
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this._primaryKeyColumn = primaryKeyColumn;
    }

    public String getPrimaryKeyValue() {
        return this._primaryKeyValue;
    }

    public void setPrimaryKeyValue(String primaryKeyValue) {
        this._primaryKeyValue = primaryKeyValue;
    }

    public void setUniqueColumns(String[] cols) {
        this._uniqueColumns = cols;
    }

    public String[] getUniqueColumns() {
        return this._uniqueColumns;
    }

    protected PluginValue newPluginValue(String property) {
        return new JDBCSeqValue(property);
    }

    protected void addStandardProperties(StringBuffer props) {
        super.addStandardProperties(props);
        this.appendProperty(props, PROP_TABLE, this._table);
        this.appendProperty(props, PROP_SEQUENCE_COL, this._sequenceColumn);
        this.appendProperty(props, PROP_PK_COL, this._primaryKeyColumn);
        this.appendProperty(props, PROP_PK_VALUE, this._primaryKeyValue);
        if (this._uniqueColumns != null && this._uniqueColumns.length > 0) {
            this.appendProperty(props, PROP_UNIQUE, StringUtils.join((Object[])this._uniqueColumns, (char)'|'));
        }
    }
}

