/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.Args;
import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.kernel.exps.FilterValueImpl;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.meta.ClassMetaData;

public class IndexOf
extends AbstractVal {
    private final Val _val1;
    private final Val _val2;
    private ClassMetaData _meta = null;
    private Class _cast = null;

    public IndexOf(Val val1, Val val2) {
        this._val1 = val1;
        this._val2 = val2;
    }

    public Val getVal1() {
        return this._val1;
    }

    public Val getVal2() {
        return this._val2;
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    public Class getType() {
        if (this._cast != null) {
            return this._cast;
        }
        return Integer.TYPE;
    }

    public void setImplicitType(Class type) {
        this._cast = type;
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState s1 = this._val1.initialize(sel, ctx, 0);
        ExpState s2 = this._val2.initialize(sel, ctx, 0);
        return new BinaryOpExpState(sel.and(s1.joins, s2.joins), s1, s2);
    }

    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
    }

    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        this._val1.selectColumns(sel, ctx, bstate.state1, true);
        this._val2.selectColumns(sel, ctx, bstate.state2, true);
    }

    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false);
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, null, null);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert(res.getObject(this, 1012, null), this.getType());
    }

    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        this._val1.calculateValue(sel, ctx, bstate.state1, null, null);
        this._val2.calculateValue(sel, ctx, bstate.state2, null, null);
    }

    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        FilterValue search;
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        FilterValueImpl str = new FilterValueImpl(sel, ctx, bstate.state1, this._val1);
        FilterValue start = null;
        if (this._val2 instanceof Args) {
            FilterValue[] filts = ((Args)this._val2).newFilterValues(sel, ctx, bstate.state2);
            search = filts[0];
            start = filts[1];
        } else {
            search = new FilterValueImpl(sel, ctx, bstate.state2, this._val2);
        }
        ctx.store.getDBDictionary().indexOf(sql2, str, search, start);
    }

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val1.acceptVisit(visitor);
        this._val2.acceptVisit(visitor);
        visitor.exit(this);
    }

    public int getId() {
        return 10;
    }
}

