/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.productdataservice;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.faktorips.productdataservice.FileReaderUtil;
import org.faktorips.runtime.internal.toc.ReadonlyTableOfContents;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TocProvider {
    private final transient ReadonlyTableOfContents toc;
    private final transient String tocData;

    public TocProvider(URL tocUrl) {
        DocumentBuilder docBuilder = this.createDocumentBuilder();
        this.toc = this.loadToc(tocUrl, docBuilder);
        this.tocData = this.loadTocData(tocUrl);
    }

    public ReadonlyTableOfContents getTableOfContents() {
        return this.toc;
    }

    public String getTableOfContentsData() {
        return this.tocData;
    }

    public String getProductDataVersion() {
        return this.toc.getProductDataVersion();
    }

    private final DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new RuntimeException("Error creaing document builder.", e1);
        }
        return builder;
    }

    private ReadonlyTableOfContents loadToc(URL tocUrl, DocumentBuilder docBuilder) {
        InputStream is = null;
        try {
            is = tocUrl.openStream();
            Document doc = docBuilder.parse(is);
            Element tocElement = doc.getDocumentElement();
            ReadonlyTableOfContents newToc = new ReadonlyTableOfContents();
            newToc.initFromXml(tocElement);
            ReadonlyTableOfContents readonlyTableOfContents = newToc;
            return readonlyTableOfContents;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading contents from " + tocUrl, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing stream of " + tocUrl.getFile(), e);
                }
            }
        }
    }

    private String loadTocData(URL tocUrl) {
        try {
            String newTocData = FileReaderUtil.readContent(tocUrl);
            return newTocData;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading contents from " + tocUrl.getFile(), e);
        }
    }
}

