/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.productdataservice;

import java.io.IOException;
import java.net.URL;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import org.faktorips.productdataservice.FileReaderUtil;
import org.faktorips.productdataservice.IProductDataService;
import org.faktorips.productdataservice.TocProvider;
import org.faktorips.productdataservice.XmlTimestampData;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;

@Stateless
public class ProductDataService
implements IProductDataService {
    public static final String TOCFILE_PROPERTY_KEY = "org.faktorips.pds.tocfile";
    private volatile transient TocProvider tocProvider;
    private final transient ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    @Resource
    private String tocFileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TocProvider getTocProvider() {
        TocProvider result = this.tocProvider;
        if (result == null) {
            ProductDataService productDataService = this;
            synchronized (productDataService) {
                result = this.tocProvider;
                if (result == null) {
                    if (this.tocFileName == null) {
                        throw new IllegalArgumentException("You have to set the tocFileName in your EJB environment.");
                    }
                    this.tocProvider = result = new TocProvider(this.classLoader.getResource(this.tocFileName));
                }
            }
        }
        return result;
    }

    public XmlTimestampData getTocData() {
        return new XmlTimestampData(this.getTocProvider().getTableOfContentsData(), this.getTocProvider().getProductDataVersion());
    }

    public String getProductDataVersion() {
        return this.getTocProvider().getProductDataVersion();
    }

    public XmlTimestampData getProductCmptData(String ipsObjectId) {
        ProductCmptTocEntry entry = this.getTocProvider().getTableOfContents().getProductCmptTocEntry(ipsObjectId);
        return this.getDataForTocEntry((TocEntryObject)entry);
    }

    public XmlTimestampData getTestCaseData(String qName) {
        TestCaseTocEntry entry = this.getTocProvider().getTableOfContents().getTestCaseTocEntryByQName(qName);
        return this.getDataForTocEntry((TocEntryObject)entry);
    }

    public XmlTimestampData getTableContent(String qName) {
        TableContentTocEntry entry = this.getTocProvider().getTableOfContents().getTableTocEntryByQualifiedTableName(qName);
        return this.getDataForTocEntry((TocEntryObject)entry);
    }

    public XmlTimestampData getEnumContent(String className) {
        EnumContentTocEntry entry = this.getTocProvider().getTableOfContents().getEnumContentTocEntry(className);
        return this.getDataForTocEntry((TocEntryObject)entry);
    }

    private XmlTimestampData getDataForTocEntry(TocEntryObject entry) {
        String content;
        if (entry == null) {
            return null;
        }
        String xmlResourceName = entry.getXmlResourceName();
        URL url = this.classLoader.getResource(xmlResourceName);
        if (url == null) {
            throw new RuntimeException("Toc file containts invalid xml resource name: " + entry.getXmlResourceName());
        }
        try {
            content = FileReaderUtil.readContent(url);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading contents from " + url.getFile(), e);
        }
        return new XmlTimestampData(content, this.getProductDataVersion());
    }
}

