/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.apache.openejb.client.ClientInstance;
import org.apache.openejb.client.Injection;
import org.apache.openejb.client.InjectionMetaData;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        args = Main.siftArgs(args);
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.openejb.client");
        InitialContext initialContext = new InitialContext();
        String path = (String)initialContext.lookup("java:comp/path");
        File file = new File(path);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader = classLoader == null ? new URLClassLoader(new URL[]{file.toURL()}) : new URLClassLoader(new URL[]{file.toURL()}, classLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
        String mainClassName = (String)initialContext.lookup("java:comp/mainClass");
        Class<?> mainClass = classLoader.loadClass(mainClassName);
        final Method mainMethod = mainClass.getMethod("main", String[].class);
        Class<?> callbackHandlerClass = null;
        try {
            String callbackHandlerName = (String)initialContext.lookup("java:comp/callbackHandler");
            callbackHandlerClass = classLoader.loadClass(callbackHandlerName);
        }
        catch (NameNotFoundException ignored) {
            // empty catch block
        }
        InjectionMetaData injectionMetaData = (InjectionMetaData)initialContext.lookup("java:comp/injections");
        ClientInstance.get().setComponent(InjectionMetaData.class, injectionMetaData);
        for (Injection injection : injectionMetaData.getInjections()) {
            try {
                Object value = initialContext.lookup("java:comp/env/" + injection.getJndiName());
                Class<?> target = classLoader.loadClass(injection.getTargetClass());
                Field field = target.getDeclaredField(injection.getName());
                Main.setAccessible(field);
                field.set(null, value);
            }
            catch (Throwable e) {
                System.err.println("Injection FAILED: class=" + injection.getTargetClass() + ", name=" + injection.getName() + ", jndi-ref=" + injection.getJndiName());
                e.printStackTrace();
            }
        }
        final Object[] mainArgs = new Object[]{args};
        if (callbackHandlerClass == null) {
            Main.invoke(mainMethod, mainArgs);
        } else {
            CallbackHandler callbackHandler = (CallbackHandler)callbackHandlerClass.newInstance();
            Main.loadJassLoginConfig(classLoader);
            LoginContext loginContext = new LoginContext("ClientLogin", callbackHandler);
            loginContext.login();
            Subject subject = loginContext.getSubject();
            try {
                Subject.doAs(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Main.invoke(mainMethod, mainArgs);
                        return null;
                    }
                });
            }
            finally {
                loginContext.logout();
            }
        }
    }

    private static void invoke(Method mainMethod, Object[] mainArgs) throws Exception {
        try {
            mainMethod.invoke(null, mainArgs);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new Error(e);
        }
    }

    private static void loadJassLoginConfig(ClassLoader classLoader) {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = classLoader.getResource("client.login.conf")) != null) {
            System.setProperty("java.security.auth.login.config", URLDecoder.decode(resource.toExternalForm()));
        }
    }

    private static String[] siftArgs(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.indexOf("-D") == -1) {
                argsList.add(arg);
                continue;
            }
            String prop = arg.substring(arg.indexOf("-D") + 2, arg.indexOf("="));
            String val = arg.substring(arg.indexOf("=") + 1);
            System.setProperty(prop, val);
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    private static void setAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }
}

