/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.ServerMetaData;

public class EJBHomeHandle
implements Externalizable,
HomeHandle {
    protected transient EJBHomeProxy ejbHomeProxy;
    protected transient EJBHomeHandler handler;

    public EJBHomeHandle() {
    }

    public EJBHomeHandle(EJBHomeProxy proxy) {
        this.ejbHomeProxy = proxy;
        this.handler = this.ejbHomeProxy.getEJBHomeHandler();
    }

    protected void setEJBHomeProxy(EJBHomeProxy ejbHomeProxy) {
        this.ejbHomeProxy = ejbHomeProxy;
        this.handler = ejbHomeProxy.getEJBHomeHandler();
    }

    public EJBHome getEJBHome() throws RemoteException {
        return this.ejbHomeProxy;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        this.handler.client.writeExternal(out);
        EJBMetaDataImpl ejb = this.handler.ejb;
        out.writeObject(EJBHomeHandle.getClassName(ejb.homeClass));
        out.writeObject(EJBHomeHandle.getClassName(ejb.remoteClass));
        out.writeObject(EJBHomeHandle.getClassName(ejb.keyClass));
        out.writeByte(ejb.type);
        out.writeUTF(ejb.deploymentID);
        out.writeShort(ejb.deploymentCode);
        this.handler.server.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        ClientMetaData client = new ClientMetaData();
        EJBMetaDataImpl ejb = new EJBMetaDataImpl();
        ServerMetaData server = new ServerMetaData();
        client.readExternal(in);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ejb.homeClass = EJBHomeHandle.loadClass(classLoader, (String)in.readObject());
        ejb.remoteClass = EJBHomeHandle.loadClass(classLoader, (String)in.readObject());
        ejb.keyClass = EJBHomeHandle.loadClass(classLoader, (String)in.readObject());
        ejb.type = in.readByte();
        ejb.deploymentID = in.readUTF();
        ejb.deploymentCode = in.readShort();
        server.readExternal(in);
        this.handler = EJBHomeHandler.createEJBHomeHandler(ejb, server, client);
        this.ejbHomeProxy = this.handler.createEJBHomeProxy();
    }

    private static String getClassName(Class clazz) {
        return clazz == null ? null : clazz.getName();
    }

    private static Class loadClass(ClassLoader classLoader, String homeClassName) throws ClassNotFoundException {
        return homeClassName == null ? null : Class.forName(homeClassName, true, classLoader);
    }
}

