/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.URI;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.ConnectionStrategy;
import org.apache.openejb.client.HttpConnectionFactory;
import org.apache.openejb.client.MulticastConnectionFactory;
import org.apache.openejb.client.Registry;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SocketConnectionFactory;
import org.apache.openejb.client.StickyConnectionStrategy;

public class ConnectionManager {
    private static Registry<ConnectionFactory> factories = Registry.create(ConnectionFactory.class);
    private static Registry<ConnectionStrategy> strategies = Registry.create(ConnectionStrategy.class);

    public static Connection getConnection(ClusterMetaData cluster, ServerMetaData server) throws IOException {
        ConnectionStrategy strategy;
        String name = cluster.getConnectionStrategy();
        if (name == null) {
            name = "default";
        }
        if ((strategy = strategies.get(name)) == null) {
            throw new IOException("Unsupported ConnectionStrategy  \"" + name + "\"");
        }
        return strategy.connect(cluster, server);
    }

    public static Connection getConnection(URI uri) throws IOException {
        String scheme = uri.getScheme();
        ConnectionFactory factory = factories.get(scheme);
        if (factory == null) {
            throw new IOException("Unsupported ConnectionFactory URI scheme  \"" + scheme + "\"");
        }
        return factory.getConnection(uri);
    }

    public static void registerFactory(String scheme, ConnectionFactory factory) {
        factories.register(scheme, factory);
    }

    public static ConnectionFactory unregisterFactory(String scheme) {
        return factories.unregister(scheme);
    }

    public static void registerStrategy(String scheme, ConnectionStrategy factory) {
        strategies.register(scheme, factory);
    }

    public static ConnectionStrategy unregisterStrategy(String scheme) {
        return strategies.unregister(scheme);
    }

    public static void setFactory(ConnectionFactory factory) throws IOException {
        ConnectionManager.registerFactory("default", factory);
    }

    static {
        SocketConnectionFactory ejbdFactory = new SocketConnectionFactory();
        factories.register("default", ejbdFactory);
        factories.register("ejbd", ejbdFactory);
        factories.register("ejbds", ejbdFactory);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory();
        factories.register("http", httpFactory);
        factories.register("https", httpFactory);
        factories.register("multicast", new MulticastConnectionFactory());
        strategies.register("default", new StickyConnectionStrategy());
    }
}

