/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected volatile String _validationQuery = null;
    protected volatile boolean _rollbackAfterValidation = false;
    protected KeyedObjectPool _pool = null;
    private Map muteMap = new HashMap();
    private Map cleanupMap = new HashMap();
    private WeakHashMap pcMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory(this);
        this._validationQuery = validationQuery;
    }

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery, boolean rollbackAfterValidation) {
        this(cpds, pool, validationQuery);
        this._rollbackAfterValidation = rollbackAfterValidation;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public void setRollbackAfterValidation(boolean rollbackAfterValidation) {
        this._rollbackAfterValidation = rollbackAfterValidation;
    }

    public synchronized void setPool(KeyedObjectPool pool) throws SQLException {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLNestedException("Cannot set the pool on this factory", e);
            }
        }
        this._pool = pool;
    }

    public synchronized KeyedObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject(Object key) throws Exception {
        PooledConnectionAndInfo obj = null;
        UserPassKey upkey = (UserPassKey)key;
        PooledConnection pc = null;
        String username = upkey.getUsername();
        String password = upkey.getPassword();
        pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, password);
        if (pc == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pc.addConnectionEventListener(this);
        obj = new PooledConnectionAndInfo(pc, username, password);
        this.pcMap.put(pc, obj);
        this.cleanupListeners();
        return obj;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (obj instanceof PooledConnectionAndInfo) {
            PooledConnection pc = ((PooledConnectionAndInfo)obj).getPooledConnection();
            this.cleanupMap.put(pc, null);
            this.muteMap.put(pc, null);
            pc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateObject(Object key, Object obj) {
        boolean valid = false;
        if (!(obj instanceof PooledConnectionAndInfo)) return false;
        PooledConnection pconn = ((PooledConnectionAndInfo)obj).getPooledConnection();
        String query = this._validationQuery;
        if (null == query) return true;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        this.muteMap.put(pconn, null);
        try {
            conn = pconn.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            valid = rset.next();
            if (!this._rollbackAfterValidation) return valid;
            conn.rollback();
            return valid;
        }
        catch (Exception e) {
            valid = false;
            return valid;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable t) {}
            }
            this.muteMap.remove(pconn);
        }
    }

    public void passivateObject(Object key, Object obj) {
    }

    public void activateObject(Object key, Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.muteMap.containsKey(pc)) {
            PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(info.getUserPassKey(), info);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                this.cleanupMap.put(pc, null);
                this.muteMap.put(pc, null);
                try {
                    this._pool.invalidateObject(info.getUserPassKey(), info);
                }
                catch (Exception e3) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
                    e3.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (this.cleanupMap.containsKey(pc)) {
            return;
        }
        try {
            if (null != event.getSQLException()) {
                System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
            }
            this.cleanupMap.put(pc, null);
            this.muteMap.put(pc, null);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(info.getUserPassKey(), info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupListeners() {
        try {
            Iterator iter = this.cleanupMap.keySet().iterator();
            while (iter.hasNext()) {
                PooledConnection pc = (PooledConnection)iter.next();
                this.pcMap.remove(pc);
                this.muteMap.remove(pc);
                try {
                    pc.removeConnectionEventListener(this);
                }
                catch (Exception ex) {
                    System.err.println("EXCEPTION REMOVING CONNECTION LISTENER ");
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println("EXCEPTION CLEANING UP CONNECTION LISTENERS ");
            e.printStackTrace();
        }
        finally {
            this.cleanupMap.clear();
        }
    }
}

