/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ServicePool
implements ServerService {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.SERVICEPOOL, (String)"org.apache.openejb.util.resources");
    private final ServerService next;
    private final Executor executor;
    private final ThreadPoolExecutor threadPool;
    private final AtomicBoolean stop = new AtomicBoolean();

    public ServicePool(ServerService next, String name, Properties properties) {
        this(next, name, new Options(properties).get("threads", 100));
    }

    public ServicePool(ServerService next, final String name, int threads) {
        this.next = next;
        int keepAliveTime = 300000;
        this.threadPool = new ThreadPoolExecutor(threads, threads, 300000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.threadPool.setThreadFactory(new ThreadFactory(){
            private volatile int id = 0;

            public Thread newThread(Runnable arg0) {
                Thread thread = new Thread(arg0, name + " " + this.getNextID());
                return thread;
            }

            private int getNextID() {
                return this.id++;
            }
        });
        this.executor = this.threadPool;
        SystemInstance.get().setComponent(ServicePool.class, (Object)this);
    }

    public ServicePool(ServerService next, Executor executor) {
        this.next = next;
        this.executor = executor;
        this.threadPool = null;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(final Socket socket) throws ServiceException, IOException {
        final Runnable service = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (ServicePool.this.stop.get()) {
                        return;
                    }
                    ServicePool.this.next.service(socket);
                }
                catch (SecurityException e) {
                    log.error("Security error: " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable e) {
                    log.error("Unexpected error", e);
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable t) {
                        log.warning("Error while closing connection with client", t);
                    }
                }
            }
        };
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Runnable ctxCL = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(tccl);
                try {
                    service.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        };
        this.executor.execute(ctxCL);
    }

    public void init(Properties props) throws Exception {
        this.next.init(props);
    }

    public void start() throws ServiceException {
        this.next.start();
    }

    public void stop() throws ServiceException {
        this.next.stop();
    }

    public String getName() {
        return this.next.getName();
    }

    public String getIP() {
        return this.next.getIP();
    }

    public int getPort() {
        return this.next.getPort();
    }
}

