/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.resource.spi.ResourceAdapter;
import org.apache.log4j.MDC;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryRegistry;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceAccessController;
import org.apache.openejb.server.ServiceDaemon;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceLogger;
import org.apache.openejb.server.ServicePool;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.ReflectionUtil;

public class ServiceManager {
    static Messages messages = new Messages("org.apache.openejb.server.util.resources");
    static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE, (String)"org.apache.openejb.server.util.resources");
    private static ServiceManager manager;
    private static ServerService[] daemons;
    private boolean stop = false;

    public static ServiceManager getManager() {
        if (manager == null) {
            manager = new ServiceManager();
        }
        return manager;
    }

    public static ServiceManager get() {
        return manager;
    }

    public void init() throws Exception {
        try {
            MDC.put((String)"SERVER", (Object)"main");
            InetAddress localhost = InetAddress.getLocalHost();
            MDC.put((String)"HOST", (Object)localhost.getHostName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        DiscoveryRegistry registry = new DiscoveryRegistry();
        SystemInstance.get().setComponent(DiscoveryRegistry.class, (Object)registry);
        ServiceFinder serviceFinder = new ServiceFinder("META-INF/");
        Map availableServices = serviceFinder.mapAvailableServices(ServerService.class);
        ArrayList<ServerService> enabledServers = new ArrayList<ServerService>();
        OpenEjbConfiguration conf = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        for (Map.Entry entry : availableServices.entrySet()) {
            String serviceName = (String)entry.getKey();
            Properties serviceProperties = (Properties)entry.getValue();
            logger.debug("Processing ServerService(id=" + serviceName + ")");
            this.overrideProperties(serviceName, serviceProperties);
            serviceProperties.setProperty("name", serviceName);
            if (conf != null && conf.facilities != null) {
                ServiceInfo info = new ServiceInfo();
                info.className = ((Class)serviceProperties.get(ServerService.class)).getName();
                info.service = "ServerService";
                info.id = serviceName;
                info.properties = serviceProperties;
                conf.facilities.services.add(info);
            }
            boolean enabled = this.isEnabled(serviceProperties);
            logger.debug("Found ServerService(id=" + serviceName + ", disabled=" + !enabled + ")");
            if (!enabled) continue;
            Class serviceClass = (Class)serviceProperties.get(ServerService.class);
            logger.debug("Creating ServerService(id=" + serviceName + ")");
            try {
                ServerService service = null;
                ObjectRecipe recipe = new ObjectRecipe(serviceClass);
                try {
                    if (ReflectionUtil.findStaticFactory((Class)serviceClass, (String)"createServerService", null, null) != null) {
                        recipe = new ObjectRecipe(serviceClass, "createServerService");
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                service = (ServerService)recipe.create(serviceClass.getClassLoader());
                if (service instanceof DiscoveryAgent) {
                    DiscoveryAgent agent = (DiscoveryAgent)((Object)service);
                    registry.addDiscoveryAgent(agent);
                }
                if (!(service instanceof SelfManaging)) {
                    service = new ServicePool(service, serviceName, serviceProperties);
                    service = new ServiceLogger(service);
                    service = new ServiceAccessController(service);
                    service = new ServiceDaemon(service);
                }
                service.init(serviceProperties);
                enabledServers.add(service);
            }
            catch (Throwable t) {
                logger.error("service.instantiation.err", t, new Object[]{serviceClass.getName(), t.getClass().getName(), t.getMessage()});
            }
        }
        daemons = enabledServers.toArray(new ServerService[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overrideProperties(String serviceName, Properties serviceProperties) throws IOException {
        FileUtils base = SystemInstance.get().getBase();
        File conf = base.getDirectory("conf");
        if (conf.exists()) {
            File serviceConfig = new File(conf, serviceName + ".properties");
            if (serviceConfig.exists()) {
                FileInputStream in = new FileInputStream(serviceConfig);
                try {
                    serviceProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            FileOutputStream out = new FileOutputStream(serviceConfig);
            try {
                String rawPropsContent = (String)serviceProperties.get(Properties.class);
                out.write(rawPropsContent.getBytes());
            }
            finally {
                out.close();
            }
        }
        String prefix = serviceName + ".";
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        for (Map.Entry<Object, Object> entry1 : sysProps.entrySet()) {
            String key = (String)entry1.getKey();
            Object value = entry1.getValue();
            if (!(value instanceof String) || !key.startsWith(prefix)) continue;
            key = key.replaceFirst(prefix, "");
            serviceProperties.setProperty(key, (String)value);
        }
    }

    private boolean isEnabled(Properties props) {
        String disabled = props.getProperty("disabled", "");
        return !disabled.equalsIgnoreCase("yes") && !disabled.equalsIgnoreCase("true");
    }

    public synchronized void start() throws ServiceException {
        this.start(true);
    }

    public synchronized void start(boolean block) throws ServiceException {
        boolean display;
        boolean bl = display = System.getProperty("openejb.nobanner") == null;
        if (display) {
            System.out.println("  ** Starting Services **");
            this.printRow("NAME", "IP", "PORT");
        }
        for (int i = 0; i < daemons.length; ++i) {
            ServerService d = daemons[i];
            try {
                d.start();
                if (!display || d.getPort() == -1) continue;
                this.printRow(d.getName(), d.getIP(), d.getPort() + "");
                continue;
            }
            catch (Exception e) {
                logger.fatal("Service Start Failed: " + d.getName() + " " + d.getIP() + " " + d.getPort() + ": " + e.getMessage());
                if (!display) continue;
                this.printRow(d.getName(), "----", "FAILED");
            }
        }
        if (display) {
            System.out.println("-------");
            System.out.println("Ready!");
        }
        if (!block) {
            return;
        }
        try {
            while (!this.stop) {
                this.wait(Long.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            logger.fatal("Unable to keep the server thread alive. Received exception: " + t.getClass().getName() + " : " + t.getMessage());
        }
        logger.info("Stopping Remote Server");
    }

    public synchronized void stop() throws ServiceException {
        logger.info("Received stop signal");
        this.stop = true;
        try {
            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            NamingEnumeration<Binding> namingEnumeration = null;
            try {
                namingEnumeration = containerSystem.getJNDIContext().listBindings("openejb/resourceAdapter");
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                Binding binding = (Binding)namingEnumeration.nextElement();
                Object object = binding.getObject();
                ResourceAdapter resourceAdapter = (ResourceAdapter)object;
                try {
                    resourceAdapter.stop();
                }
                catch (Exception e) {
                    logger.fatal("ResourceAdapter Shutdown Failed: " + binding.getName(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            logger.fatal("Unable to get ResourceAdapters from JNDI.  Stop must be called on them for proper vm shutdown.", e);
        }
        for (int i = 0; i < daemons.length; ++i) {
            try {
                daemons[i].stop();
                continue;
            }
            catch (ServiceException e) {
                logger.fatal("Service Shutdown Failed: " + daemons[i].getName() + ".  Exception: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        this.notifyAll();
    }

    private void printRow(String col1, String col2, String col3) {
        col1 = col1 + "                    ";
        col1 = col1.substring(0, 20);
        col2 = col2 + "                    ";
        col2 = col2.substring(0, 15);
        col3 = col3 + "                    ";
        col3 = col3.substring(0, 6);
        StringBuffer sb = new StringBuffer(50);
        sb.append("  ").append(col1);
        sb.append(" ").append(col2);
        sb.append(" ").append(col3);
        System.out.println(sb.toString());
    }

    public static class ServiceFinder {
        private final ResourceFinder resourceFinder;
        private ClassLoader classLoader;

        public ServiceFinder(String basePath) {
            this(basePath, Thread.currentThread().getContextClassLoader());
        }

        public ServiceFinder(String basePath, ClassLoader classLoader) {
            this.resourceFinder = new ResourceFinder(basePath, classLoader);
            this.classLoader = classLoader;
        }

        public Map mapAvailableServices(Class interfase) throws IOException, ClassNotFoundException {
            Map services = this.resourceFinder.mapAvailableProperties(ServerService.class.getName());
            for (Map.Entry entry : services.entrySet()) {
                String name = (String)entry.getKey();
                Properties properties = (Properties)entry.getValue();
                String className = properties.getProperty("className");
                if (className == null && (className = properties.getProperty("classname")) == null) {
                    className = properties.getProperty("server");
                }
                Class<?> impl = this.classLoader.loadClass(className);
                properties.put(interfase, impl);
                String rawProperties = this.resourceFinder.findString(interfase.getName() + "/" + name);
                properties.put(Properties.class, rawProperties);
            }
            return services;
        }
    }
}

