/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.log4j.MDC;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;

public class ServiceLogger
implements ServerService {
    Messages messages = new Messages("org.apache.openejb.server.util.resources");
    Logger logger;
    boolean logOnSuccess;
    boolean logOnFailure;
    ServerService next;

    public ServiceLogger(ServerService next) {
        this.next = next;
    }

    public void init(Properties props) throws Exception {
        this.logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("service." + this.getName()), (String)"org.apache.openejb.server.util.resources");
        this.next.init(props);
    }

    public void start() throws ServiceException {
        this.next.start();
    }

    public void stop() throws ServiceException {
        this.next.stop();
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("service(in,out)");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        InetAddress client = socket.getInetAddress();
        try {
            MDC.put((String)"HOST", (Object)client.getHostName());
            MDC.put((String)"SERVER", (Object)this.getName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.next.service(socket);
        }
        catch (Exception e) {
            this.logger.error("[failure] " + socket.getPort() + " - " + client.getHostName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void logIncoming() {
        this.logger.info("incomming request");
    }

    private void logSuccess() {
        this.logger.info("successful request");
    }

    private void logFailure(Exception e) {
        this.logger.error(e.getMessage());
    }

    public String getName() {
        return this.next.getName();
    }

    public String getIP() {
        return this.next.getIP();
    }

    public int getPort() {
        return this.next.getPort();
    }
}

