/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DontStartServerException;
import org.apache.openejb.server.Server;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.xbean.finder.ResourceFinder;

public class Main {
    private static Messages messages = new Messages(Main.class);

    public static void main(String[] args) throws SystemExitException {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(Main.option("v", "version", "cmd.start.opt.version"));
        options.addOption(Main.option("h", "help", "cmd.start.opt.help"));
        options.addOption(Main.option(null, "conf", "file", "cmd.start.opt.conf", new Object[0]));
        options.addOption(Main.option(null, "local-copy", "boolean", "cmd.start.opt.localCopy", new Object[0]));
        options.addOption(Main.option(null, "examples", "cmd.start.opt.examples"));
        ResourceFinder finder = new ResourceFinder("META-INF/");
        Set services = null;
        try {
            Map serviceEntries = finder.mapAvailableProperties(ServerService.class.getName());
            services = serviceEntries.keySet();
            for (String service : services) {
                options.addOption(Main.option(null, service + "-port", "int", "cmd.start.opt.port", service));
                options.addOption(Main.option(null, service + "-bind", "host", "cmd.start.opt.bind", service));
            }
        }
        catch (IOException e) {
            services = Collections.EMPTY_SET;
        }
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            Main.help(options);
            throw new SystemExitException(-1);
        }
        if (line.hasOption("help")) {
            Main.help(options);
            return;
        }
        if (line.hasOption("version")) {
            OpenEjbVersion.get().print(System.out);
            return;
        }
        if (line.hasOption("examples")) {
            try {
                String text = finder.findString("org.apache.openejb.cli/start.examples");
                System.out.println(text);
                return;
            }
            catch (IOException e) {
                System.err.println("Unable to print examples:");
                e.printStackTrace();
                throw new SystemExitException(-2);
            }
        }
        Properties props = SystemInstance.get().getProperties();
        if (line.hasOption("conf")) {
            props.setProperty("openejb.configuration", line.getOptionValue("conf"));
        } else if (line.hasOption("local-copy")) {
            String value = line.getOptionValue("local-copy");
            if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
                props.setProperty("openejb.localcopy", "false");
            } else {
                props.setProperty("openejb.localcopy", "true");
            }
        }
        for (String service : services) {
            String[] opts;
            for (String opt : opts = new String[]{"port", "bind"}) {
                String option = service + "-" + opt;
                if (!line.hasOption(option)) continue;
                props.setProperty(service + "." + opt, line.getOptionValue(option));
            }
        }
        try {
            SystemInstance system = SystemInstance.get();
            File libs = system.getHome().getDirectory("lib");
            system.getClassPath().addJarsToPath(libs);
            Main.initServer();
        }
        catch (DontStartServerException ignored) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("start [options]", "\n" + Main.i18n("cmd.start.description", new Object[0]), options, "\n");
    }

    private static Option option(String shortOpt, String longOpt, String description) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withDescription((String)Main.i18n(description, new Object[0]));
        return OptionBuilder.create((String)shortOpt);
    }

    private static Option option(String shortOpt, String longOpt, String argName, String description, Object ... details) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Main.i18n(description, details));
        return OptionBuilder.create((String)shortOpt);
    }

    private static String i18n(String key, Object ... details) {
        return messages.format(key, details);
    }

    private static void initServer() throws Exception {
        Server server = new Server();
        server.init(SystemInstance.get().getProperties());
        server.start();
    }
}

